% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/radspline.R
\name{radspline}
\alias{radspline}
\title{Radial basis spline specification}
\usage{
radspline(
  nknots,
  border,
  poverlap = 2,
  k = 2,
  width,
  type = "hexagonal",
  longlat = FALSE,
  eborder,
  ...
)
}
\arguments{
\item{nknots}{The approximate number of knots locations.
Can be a vector of positive integers for successive
samplings. See Details.}

\item{border}{A \code{\link[sp]{SpatialPolygons-class}}
object.  If \code{eborder} is not supplied, this will
be used to determine the sampling region for the knots.
See Details.}

\item{poverlap}{The proportional amount of overlap (>=1)
beyond the nearest neighbor knots.  Default is 2.}

\item{k}{The order of the Wendland covariance function.}

\item{width}{The width for the border enlargement.}

\item{type}{The sampling type for
\code{\link[sp]{spsample}}.  The default is
\code{"hexagonal"}.}

\item{longlat}{A logical value indicating whether Great
Circle distances should be used (\code{TRUE}) or
Euclidean distances (\code{FALSE}).  The default is
\code{FALSE}.}

\item{eborder}{A \code{\link[sp]{SpatialPolygons-class}}
object.  The enlarged border from which the knots will
be selected.  If not supplied, this is automatically
computed using \code{border} and \code{width}.}

\item{...}{Additional arguments passed to
\code{\link[sp]{spsample}}.}
}
\value{
A \code{hero_radspline} object.
}
\description{
\code{radspline} specifies a set of radial basis splines.
\code{nknots} is the approximate number of knots to
sample in the (usually) enlarged study area.  If
\code{eborder} is not provided, then \code{eborder} is
automatically constructed by enlarging the \code{border}
object using the \code{\link{enlarge}} function and
\code{width}. See Details for additional information
about sampling the knot locations.
}
\details{
The \code{\link[sp]{spsample}} function is used to
"automatically" select the knot locations within
\code{eborder}.  \code{nknots} corresponds to the
\code{n} argument in that function.  A hexagonal sampling
scheme is used by default, but other options are
available.

Great circle distance IS NOT used in sampling from the
regular grid.  This is computationally expensive, so it
has not been implemented.  Great circle distance is only
used  when the constructed \code{hero_radspline} is
evaluated (and \code{longlat = TRUE}).
}
\examples{
border = border.grid(lon, lat)
r = radspline(nknots = c(36, 36 * 4), border = border)
# default color scheme
plot(r)
# change color and point styles of points,
# and background of original domain
plot(r, blist = list(col = "yellow"),
        glist = list(col = c("blue", "orange"),
                     pch =  3:4))
}
