% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hermite_estimator_bivar.R
\name{cum_prob.hermite_estimator_bivar}
\alias{cum_prob.hermite_estimator_bivar}
\title{Estimates the cumulative probabilities for a matrix of 2-d x values}
\usage{
\method{cum_prob}{hermite_estimator_bivar}(this, x, clipped = FALSE, accelerate_series = FALSE)
}
\arguments{
\item{this}{A hermite_estimator_bivar object.}

\item{x}{A numeric matrix. Each row corresponds to a 2-d coordinate.}

\item{clipped}{A boolean value. This value determines whether cumulative
probabilities are clipped to lie within the range [0,1].}

\item{accelerate_series}{A boolean value. Series acceleration has not yet 
been implemented for bivariate estimators.}
}
\value{
A numeric vector of cumulative probability values.
}
\description{
This method calculates the cumulative probability values for a matrix of 
2-d x vector values using the hermite_estimator_bivar object (this).
}
\details{
The object must be updated with observations prior to the use of this method.
}
\examples{
hermite_est <- hermite_estimator_bivar(N = 10, standardize = TRUE)
hermite_est <- update_batch(hermite_est, matrix(rnorm(30*2), nrow=30, 
ncol=2, byrow = TRUE))
cdf_est <- cum_prob(hermite_est, matrix(c(0, 0, 1, 1, 2, 2), nrow=3, ncol=2, 
byrow = TRUE))
}
