% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hermite_estimator.R
\name{quant}
\alias{quant}
\title{Estimates the quantiles at a vector of probability values}
\usage{
quant(this, p)
}
\arguments{
\item{this}{A hermite_estimator_univar object.}

\item{p}{A numeric vector. A vector of probability values.}
}
\value{
A numeric vector. The vector of quantile values associated with the
probabilities p.
}
\description{
This method utilizes the estimator (13) in paper Stephanou, Michael, 
Varughese, Melvin and Iain Macdonald. "Sequential quantiles via Hermite 
series density estimation." Electronic Journal of Statistics 11.1 (2017): 
570-607 <doi:10.1214/17-EJS1245>, with some modifications to improve the 
stability of numerical root finding. Note that this method is only applicable
to the univariate Hermite estimator i.e. est_type = "univariate".
}
\examples{
hermite_est <- hermite_estimator(N = 10, standardize = TRUE, 
est_type="univariate")
hermite_est <- update_batch(hermite_est, rnorm(30))
quant_est <- quant(hermite_est, c(0.25, 0.5, 0.75))
}
