% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/route_matrix.R
\name{route_matrix}
\alias{route_matrix}
\title{HERE Routing API: Calculate Matrix}
\usage{
route_matrix(
  origin,
  destination = origin,
  datetime = Sys.time(),
  type = "fastest",
  mode = "car",
  traffic = FALSE,
  search_range = 99999999,
  attribute = c("distance", "traveltime"),
  url_only = FALSE
)
}
\arguments{
\item{origin}{\code{sf} object, the origin locations (M) of geometry type \code{POINT}.}

\item{destination}{\code{sf} object, the destination locations (N) of geometry type \code{POINT}.}

\item{datetime}{\code{POSIXct} object, datetime for the departure.}

\item{type}{character, set the routing type: \code{"fastest"}, \code{"shortest"} or \code{"balanced"}.}

\item{mode}{character, set the transport mode: \code{"car"}, \code{"pedestrian"}, \code{"carHOV"} or \code{"truck"}.}

\item{traffic}{boolean, use real-time traffic or prediction in routing (\code{default = FALSE})? If no \code{datetime} is set, the current timestamp at the moment of the request is used for \code{datetime}.}

\item{search_range}{numeric, value in meters to limit the search radius in the route generation (\code{default = 99999999}).}

\item{attribute}{character, attributes to be calculated on the routes: \code{"distance"} or \code{"traveltime"} (\code{default = c("distance", "traveltime")}.}

\item{url_only}{boolean, only return the generated URLs (\code{default = FALSE})?}
}
\value{
A \code{data.frame}, which is an edge list containing the requested M:N route combinations.
}
\description{
Calculates a matrix of M:N, M:1 or 1:N route summaries between given points of interest (POIs) using the HERE 'Routing' API.
Various transport modes and traffic information at a provided timestamp are supported.
The requested matrix is split into (sub-)matrices of dimension 15x100 to use the
maximum matrix size per request and thereby minimize the number of overall needed requests.
The result is one route summary matrix, that fits the order of the provided POIs: \code{origIndex}, \code{destIndex}.
}
\examples{
# Provide an API Key for a HERE project
set_key("<YOUR API KEY>")

# Create routes summaries between all POIs
mat <- route_matrix(
  origin = poi,
  traffic = TRUE,
  url_only = TRUE
)
}
\references{
\href{https://developer.here.com/documentation/routing/topics/resource-calculate-matrix.html}{HERE Routing API: Calculate Matrix}
}
