% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dfr_kldist.R
\name{dfr_kldist}
\alias{dfr_kldist}
\title{KL Distance method}
\usage{
dfr_kldist(target_feat, window_size = 100, p_th = 0.9, data = NULL)
}
\arguments{
\item{target_feat}{Feature to be monitored.}

\item{window_size}{Size of the sliding window (must be > 2*stat_size)}

\item{p_th}{Probability theshold for the test statistic of the Kullback Leibler distance.}

\item{data}{Already collected data to avoid cold start.}
}
\value{
\code{dfr_kldist} object
}
\description{
Kullback Leibler Windowing method for concept drift detection.
}
\examples{
library(daltoolbox)
library(heimdall)

# This example assumes a model residual where 1 is an error and 0 is a correct prediction.

data(st_drift_examples)
data <- st_drift_examples$univariate
data$event <- NULL
data$prediction <- st_drift_examples$univariate$serie > 4


model <- dfr_kldist(target_feat='serie')

detection <- c()
output <- list(obj=model, pred=FALSE)
for (i in 1:length(data$serie)){
 output <- update_state(output$obj, data$serie[i])
 if (output$pred){
   type <- 'drift'
   output$obj <- reset_state(output$obj)
 }else{
   type <- ''
 }
 detection <- rbind(detection, list(idx=i, event=output$pred, type=type))
}

detection <- as.data.frame(detection)
detection[detection$type == 'drift',]
}
