% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/los_ra_index_plt.R
\name{los_ra_index_plt}
\alias{los_ra_index_plt}
\title{Plot LOS and Readmit Index with Variance}
\usage{
los_ra_index_plt(.data)
}
\arguments{
\item{.data}{The data supplied from \code{\link[=los_ra_index_summary_tbl]{los_ra_index_summary_tbl()}}}
}
\value{
A \code{patchwork} \code{ggplot2} plot
}
\description{
Plot the index of the length of stay and readmit rate against each other along
with the variance
}
\details{
\itemize{
\item Expects a tibble
\item Expects a Length of Stay and Readmit column, must be numeric
\item Uses \code{cowplot} to stack plots
}
}
\examples{

suppressPackageStartupMessages(library(dplyr))

data_tbl <- tibble(
  "alos"                 = runif(186, 1, 20)
  , "elos"               = runif(186, 1, 17)
  , "readmit_rate"       = runif(186, 0, .25)
  , "readmit_rate_bench" = runif(186, 0, .2)
)

los_ra_index_summary_tbl(
  .data = data_tbl
  , .max_los       = 15
  , .alos_col      = alos
  , .elos_col      = elos
  , .readmit_rate  = readmit_rate
  , .readmit_bench = readmit_rate_bench
  ) \%>\%
  los_ra_index_plt()

los_ra_index_summary_tbl(
  .data = data_tbl
  , .max_los       = 10
  , .alos_col      = alos
  , .elos_col      = elos
  , .readmit_rate  = readmit_rate
  , .readmit_bench = readmit_rate_bench
  ) \%>\%
  los_ra_index_plt()

}
\author{
Steven P. Sanderson II, MPH
}
