% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/6.hdnom.external.calibrate.R
\name{hdnom.external.calibrate}
\alias{hdnom.external.calibrate}
\title{Externally Calibrate High-Dimensional Cox Models}
\usage{
hdnom.external.calibrate(object, x, time, event, x_new, time_new, event_new,
  pred.at, ngroup = 5)
}
\arguments{
\item{object}{Model object fitted by \code{hdcox.*()} functions.}

\item{x}{Matrix of training data used for fitting the model.}

\item{time}{Survival time of the training data.
Must be of the same length with the number of rows as \code{x}.}

\item{event}{Status indicator of the training data,
normally 0 = alive, 1 = dead.
Must be of the same length with the number of rows as \code{x}.}

\item{x_new}{Matrix of predictors for the external validation data.}

\item{time_new}{Survival time of the external validation data.
Must be of the same length with the number of rows as \code{x_new}.}

\item{event_new}{Status indicator of the external validation data,
normally 0 = alive, 1 = dead.
Must be of the same length with the number of rows as \code{x_new}.}

\item{pred.at}{Time point at which external calibration should take place.}

\item{ngroup}{Number of groups to be formed for external calibration.}
}
\description{
Externally Calibrate High-Dimensional Cox Models
}
\examples{
library("survival")

# Load imputed SMART data
data(smart)
# Use the first 1000 samples as training data
# (the data used for internal validation)
x = as.matrix(smart[, -c(1, 2)])[1:1000, ]
time = smart$TEVENT[1:1000]
event = smart$EVENT[1:1000]

# Take the next 1000 samples as external calibration data
# In practice, usually use data collected in other studies
x_new = as.matrix(smart[, -c(1, 2)])[1001:2000, ]
time_new = smart$TEVENT[1001:2000]
event_new = smart$EVENT[1001:2000]

# Fit Cox model by lasso penalization
lassofit = hdcox.lasso(x, Surv(time, event), nfolds = 5, rule = "lambda.1se", seed = 11)

# External calibration
cal.ext =
  hdnom.external.calibrate(lassofit, x, time, event,
                           x_new, time_new, event_new,
                           pred.at = 365 * 5, ngroup = 5)

print(cal.ext)
summary(cal.ext)
plot(cal.ext, xlim = c(0.6, 1), ylim = c(0.6, 1))

}

