#' @title Dataset to estimate quarterly U.S. inflation
#' @description  A novel, high-dimensional dataset built by Koop and Korobilis (2023)
#'               that merges predictive signals from several mainstream aggregate
#'               macroeconomic and financial datasets. The dataset includes
#'               the FRED-QD dataset of McCracken and Ng (2020),
#'               augment with portfolio data used in Jurado et al. (2015),
#'               stock market predictors from Welch and Goyal (2008),
#'               survey data from University of Michigan consumer surveys,
#'               commodity prices from the World Bank’s Pink Sheet database,
#'               and key macroeconomic indicators from the Federal Reserve Economic Data
#'               for four economies (Canada, Germany, Japan, United Kingdom).
#'               The data is already pre-processed to perform one-step-ahead forecasts
#'               and augmented with (external) point forecasts from Koop & Korobilis (2023).
#'               The dataset spans the period 1960-Q3 to 2021-Q4.
#'
#' @format A \link{matrix} with 245 quarterly observations (rows) and 516 variables (columns).
#' \describe{
#'
#'    \item{Column 1:4}{Transformed target variables:
#'                      GDP deflator (GDPCTPI), PCE deflator (PCECTPI),
#'                      Total CPI (CPIAUCSL), Core CPI (CPILFESL)}
#'
#'    \item{Column 5:8}{First lag of the target variables}
#'
#'    \item{Column 9:12}{Second lag of the target variables}
#'
#'    \item{Column 13:16}{All four (lagged) price series transformed with second differences of logarithms}
#'
#'    \item{Column 17:452}{All remaining (lagged and transformed) signals from the
#'                         FRED-QD dataset of McCracken and Ng (2020),
#'                         portfolio data used in Jurado et al. (2015),
#'                         stock market predictors from Welch and Goyal (2008),
#'                         survey data from University of Michigan consumer surveys,
#'                         commodity prices from the World Bank’s Pink Sheet database,
#'                         and key macroeconomic indicators from the Federal Reserve Economic Data
#'                         for Canada, Germany, Japan & United Kingdom. }
#'
#'    \item{Column 453:468}{External point forecasts for quarterly GDP deflator (GDPCTPI)
#'                          generated by the MatLab Code from Koop and Korobilis (2023).
#'                          The forecasts were generated out-of-sample from 1976-Q1 to 2021-Q4.}
#'
#'    \item{Column 469:484}{External point forecasts for quarterly PCE deflator (PCECTPI)
#'                          generated by the MatLab Code from Koop and Korobilis (2023).
#'                          The forecasts were generated out-of-sample from 1976-Q1 to 2021-Q4.}
#'
#'    \item{Column 485:500}{External point forecasts for quarterly Total CPI (CPIAUCSL)
#'                          generated by the MatLab Code from Koop and Korobilis (2023).
#'                          The forecasts were generated out-of-sample from 1976-Q1 to 2021-Q4.}
#'
#'    \item{Column 501:516}{External point forecasts for quarterly Core CPI (CPILFESL)
#'                          generated by the MatLab Code from Koop and Korobilis (2023).
#'                          The forecasts were generated out-of-sample from 1976-Q1 to 2021-Q4.}
#' }
#' @references
#'
#' Jurado, K., Ludvigson, S. C., and Ng, S. (2015) "Measuring uncertainty."
#' \emph{American Economic Review}, 105 (3): 1177–1216.
#'
#' Koop, G. and Korobilis, D. (2023) "Bayesian dynamic variable selection in high dimensions."
#' \emph{International Economic Review}.
#'
#' McCracken, M., and S. Ng (2020) “FRED-QD: A Quarterly Database for Macroeconomic Research”
#' \emph{National Bureau of Economic Research}, Working Paper 26872.
#'
#' Welch, I. and Goyal, A. (2008) "A comprehensive look at the empirical performance of equity premium prediction."
#' \emph{The Review of Financial Studies}, 21 (4): 1455–1508.
#'
#' @source <https://doi.org/10.1111/iere.12623>
"inflation_data"


#' @title AR(2) benchmark forecasts for quarterly U.S. inflation
#' @description Out-of-sample one-step-ahead AR(2) benchmark forecasts for the period
#'              from 1991-Q2 to 2021-Q4. The AR(2) models are estimated with OLS and intercept.
#'
#' @format A \link{matrix} with 123 quarterly observations (rows) and 4 benchmarks (columns):
#' \describe{
#'
#'    \item{GDPCTPI}{OOS-AR2-benchmark forecast for quarterly GDP deflator (GDPCTPI).}
#'
#'    \item{PCECTPI}{OOS-AR2-benchmark forecast for quarterly PCE deflator (PCECTPI).}
#'
#'    \item{CPIAUCSL}{OOS-AR2-benchmark forecast for quarterly Total CPI (CPIAUCSL).}
#'
#'    \item{CPILFESL}{OOS-AR2-benchmark forecast for quarterly Core CPI (CPILFESL).}
#' }
#' @references
#'
#' Koop, G. and Korobilis, D. (2023) "Bayesian dynamic variable selection in high dimensions."
#' \emph{International Economic Review}.
#'
#' @source <https://doi.org/10.1111/iere.12623>
"benchmark_ar2"
