% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/R6Classes_H5T.R
\docType{class}
\name{H5T-class}
\alias{H5T-class}
\alias{H5T}
\title{Class for HDF5 datatypes.}
\value{
Object of class \code{\link{H5T}}.
}
\description{
This is the base class for all datatypes, but most have a specialised class.
This class represents an HDF5 datatype. It inherits all functions of the
\code{\link{H5RefClass}}. It is also the base class for many other classes well, specifically
\describe{
\item{Integer}{\code{\link{H5T_INTEGER}}}
\item{Bitfield}{\code{\link{H5T_BITFIELD}} (currently identical to the integer class)}
\item{Float}{\code{\link{H5T_FLOAT}}}
\item{Enum}{\code{\link{H5T_ENUM}}}
\item{Compound}{\code{\link{H5T_COMPOUND}}}
\item{String}{\code{\link{H5T_STRING}}}
\item{Complex}{\code{\link{H5T_COMPLEX}}}
\item{Array}{\code{\link{H5T_ARRAY}}}
\item{Variable Length}{\code{\link{H5T_VLEN}}}
}
}
\section{Methods}{

\describe{
\item{\code{new(id)}}{

Internal use only}

\item{\code{get_class()}}{

This function implements the HDF5-API function H5Tget_class.
Please see the documentation at \url{https://docs.hdfgroup.org/hdf5/develop/group___h5_t.html} for details.}

\item{\code{get_size(...)}}{

This function implements the HDF5-API function H5Tget_size.
Please see the documentation at \url{https://docs.hdfgroup.org/hdf5/develop/group___h5_t.html} for details.

\strong{Parameters}
\describe{
\item{...}{ignored}
}}

\item{\code{set_size(size)}}{

This function implements the HDF5-API function H5Tset_size.
Please see the documentation at \url{https://docs.hdfgroup.org/hdf5/develop/group___h5_t.html} for details.}

\item{\code{set_precision(precision)}}{

This function implements the HDF5-API function H5Tset_precision.
Please see the documentation at \url{https://docs.hdfgroup.org/hdf5/develop/group___h5_t.html} for details.}

\item{\code{get_precision()}}{

This function implements the HDF5-API function H5Tget_precision.
Please see the documentation at \url{https://docs.hdfgroup.org/hdf5/develop/group___h5_t.html} for details.}

\item{\code{set_order(order)}}{

This function implements the HDF5-API function H5Tset_order.
Please see the documentation at \url{https://docs.hdfgroup.org/hdf5/develop/group___h5_t.html} for details.}

\item{\code{get_order()}}{

This function implements the HDF5-API function H5Tget_order.
Please see the documentation at \url{https://docs.hdfgroup.org/hdf5/develop/group___h5_t.html} for details.}

\item{\code{set_offset(offset)}}{

This function implements the HDF5-API function H5Tset_offset.
Please see the documentation at \url{https://docs.hdfgroup.org/hdf5/develop/group___h5_t.html} for details.}

\item{\code{get_offset()}}{

This function implements the HDF5-API function H5Tget_offset.
Please see the documentation at \url{https://docs.hdfgroup.org/hdf5/develop/group___h5_t.html} for details.}

\item{\code{set_pad(pad)}}{

This function implements the HDF5-API function H5Tset_pad.
Please see the documentation at \url{https://docs.hdfgroup.org/hdf5/develop/group___h5_t.html} for details.}

\item{\code{get_pad()}}{

This function implements the HDF5-API function H5Tget_pad.
Please see the documentation at \url{https://docs.hdfgroup.org/hdf5/develop/group___h5_t.html} for details.}

\item{\code{copy()}}{

This function implements the HDF5-API function H5Tcopy.
Please see the documentation at \url{https://docs.hdfgroup.org/hdf5/develop/group___h5_t.html} for details.}

\item{\code{is_committed()}}{

This function implements the HDF5-API function H5Tcommitted.
Please see the documentation at \url{https://docs.hdfgroup.org/hdf5/develop/group___h5_t.html} for details.}

\item{\code{equal(dtype)}}{

This function implements the HDF5-API function H5Tequal.
Please see the documentation at \url{https://docs.hdfgroup.org/hdf5/develop/group___h5_t.html} for details.}

\item{\code{is_vlen()}}{

This function detects if the underlying type is H5T_VLEN or a variable length string. This is used to know if
after reading a dataset, memory has to be freed}

\item{\code{detect_class(dtype_class)}}{

This function implements the HDF5-API function H5Tdetect_class.
Please see the documentation at \url{https://docs.hdfgroup.org/hdf5/develop/group___h5_t.html} for details.}

\item{\code{get_native_type(direction = h5const$H5T_DIR_ASCEND)}}{

This function implements the HDF5-API function H5Tget_native_type.
Please see the documentation at \url{https://docs.hdfgroup.org/hdf5/develop/group___h5_t.html} for details.}

\item{\code{get_create_plist()}}{

This function implements the HDF5-API function H5Tget_create_plist.
Please see the documentation at \url{https://docs.hdfgroup.org/hdf5/develop/group___h5_t.html} for details.}

\item{\code{to_text(lang_type = h5const$H5LT_DDL)}}{

This function implements the HDF5-API function H5LTdtype_to_text.
Please see the documentation at \url{https://docs.hdfgroup.org/hdf5/develop/group___h5_l_t.html} for details.}

\item{\code{print(...)}}{

Prints information for the group

\strong{Parameters}
\describe{
\item{...}{ignored}
}}

\item{\code{obj_info(remove_internal_use_only = TRUE)}}{

This function implements the HDF5-API function H5Oget_info.
Please see the documentation at \url{https://docs.hdfgroup.org/hdf5/develop/group___h5_o.html} for details.}

\item{\code{get_obj_name()}}{

This function implements the HDF5-API function H5Iget_name.
Please see the documentation at \url{https://docs.hdfgroup.org/hdf5/develop/group___h5_i.html} for details.}

\item{\code{create_attr(attr_name, robj = NULL, dtype = NULL, space = NULL)}}{

This function implements the HDF5-API function H5Acreate2.
Please see the documentation at \url{https://docs.hdfgroup.org/hdf5/develop/group___h5_a.html} for details.}

\item{\code{attr_open(attr_name)}}{

This function implements the HDF5-API function H5Aopen.
Please see the documentation at \url{https://docs.hdfgroup.org/hdf5/develop/group___h5_a.html} for details.}

\item{\code{create_attr_by_name(attr_name, obj_name, robj = NULL,
  dtype = NULL, space = NULL,
  link_access_pl = h5const$H5P_DEFAULT)}}{

This function implements the HDF5-API function H5Acreate_by_name.
Please see the documentation at \url{https://docs.hdfgroup.org/hdf5/develop/group___h5_a.html} for details.}

\item{\code{attr_open_by_name(attr_name, obj_name,
  link_access_pl = h5const$H5P_DEFAULT)}}{

This function implements the HDF5-API function H5Aopen_by_name.
Please see the documentation at \url{https://docs.hdfgroup.org/hdf5/develop/group___h5_a.html} for details.}

\item{\code{attr_open_by_idx(n, obj_name, idx_type = h5const$H5_INDEX_NAME,
  order = h5const$H5_ITER_NATIVE,
  link_access_pl = h5const$H5P_DEFAULT)}}{

This function implements the HDF5-API function H5Aopen_by_idx.
Please see the documentation at \url{https://docs.hdfgroup.org/hdf5/develop/group___h5_a.html} for details.}

\item{\code{attr_exists_by_name(attr_name, obj_name,
  link_access_pl = h5const$H5P_DEFAULT)}}{

This function implements the HDF5-API function H5Aexists_by_name.
Please see the documentation at \url{https://docs.hdfgroup.org/hdf5/develop/group___h5_a.html} for details.}

\item{\code{attr_exists(attr_name)}}{

This function implements the HDF5-API function H5Aexists.
Please see the documentation at \url{https://docs.hdfgroup.org/hdf5/develop/group___h5_a.html} for details.}

\item{\code{attr_rename_by_name(old_attr_name, new_attr_name, obj_name,
  link_access_pl = h5const$H5P_DEFAULT)}}{

This function implements the HDF5-API function H5Arename_by_name.
Please see the documentation at \url{https://docs.hdfgroup.org/hdf5/develop/group___h5_a.html} for details.}

\item{\code{attr_rename(old_attr_name, new_attr_name)}}{

This function implements the HDF5-API function H5Arename.
Please see the documentation at \url{https://docs.hdfgroup.org/hdf5/develop/group___h5_a.html} for details.}

\item{\code{attr_delete(attr_name)}}{

This function implements the HDF5-API function H5Adelete.
Please see the documentation at \url{https://docs.hdfgroup.org/hdf5/develop/group___h5_a.html} for details.}

\item{\code{attr_delete_by_name(attr_name, obj_name,
  link_access_pl = h5const$H5P_DEFAULT)}}{

This function implements the HDF5-API function H5Adelete_by_name.
Please see the documentation at \url{https://docs.hdfgroup.org/hdf5/develop/group___h5_a.html} for details.}

\item{\code{attr_delete_by_idx(n, obj_name, idx_type = h5const$H5_INDEX_NAME,
  order = h5const$H5_ITER_NATIVE,
  link_access_pl = h5const$H5P_DEFAULT)}}{

This function implements the HDF5-API function H5Adelete_by_idx.
Please see the documentation at \url{https://docs.hdfgroup.org/hdf5/develop/group___h5_a.html} for details.}

\item{\code{attr_info_by_name(attr_name, obj_name,
  link_access_pl = h5const$H5P_DEFAULT)}}{

This function implements the HDF5-API function H5Aget_info_by_name.
Please see the documentation at \url{https://docs.hdfgroup.org/hdf5/develop/group___h5_a.html} for details.}

\item{\code{attr_info_by_idx(n, obj_name, idx_type = h5const$H5_INDEX_NAME,
  order = h5const$H5_ITER_NATIVE,
  link_access_pl = h5const$H5P_DEFAULT)}}{

This function implements the HDF5-API function H5Aget_info_by_idx.
Please see the documentation at \url{https://docs.hdfgroup.org/hdf5/develop/group___h5_a.html} for details.}

\item{\code{attr_name_by_idx(n, obj_name, idx_type = h5const$H5_INDEX_NAME,
  order = h5const$H5_ITER_NATIVE,
  link_access_pl = h5const$H5P_DEFAULT)}}{

This function implements the HDF5-API function H5Aget_name_by_idx.
Please see the documentation at \url{https://docs.hdfgroup.org/hdf5/develop/group___h5_a.html} for details.}

\item{\code{attr_get_number()}}{

This function implements the HDF5-API function H5Aget_num_attrs.
Please see the documentation at \url{https://support.hdfgroup.org/HDF5/doc/RM/RM_H5A.html#Annot-NumAttrs} for details.}

\item{\code{create_reference(name = ".", space = NULL)}}{

This function implements the HDF5-API function H5Rcreate. If \code{space=NULL} then a \code{H5R_OBJECT} reference
is created, otherwise a \code{H5R_DATASET_REGION} reference
Please see the documentation at \url{https://docs.hdfgroup.org/hdf5/develop/group___h5_r.html} for details.}
}}

\examples{
my_int <- h5types$H5T_NATIVE_INT
my_int$to_text()
my_int$get_size()

# Show how to commit a datatype
fname <- tempfile(fileext = ".h5")
file <- H5File$new(fname, mode = "a")
my_int$is_committed()
file$commit("my_int", my_int)
my_int$is_committed()

# can now also add attributes
h5attr(my_int, "test") <- "A string"
h5attributes(my_int)

file$close_all()
file.remove(fname)
}
\author{
Holger Hoefling
}
