% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/R6Classes_H5File.R
\docType{class}
\name{H5File-class}
\alias{H5File-class}
\alias{H5File}
\title{Class for interacting with HDF5 files.}
\value{
Object of class \code{\link{H5File}}.
}
\description{
\code{H5File} objects are are the main entry point to access HDF5 data from binary 
files. This class represents an open HDF5 File-id. It inherits all functions 
of the \code{\link{H5RefClass}}.
}
\details{
HDF5 files can be opened or generated using the \code{H5File$new()} function and
a specified file access mode. \code{H5File$new()} returns a \code{H5File} object
which can be used to access \code{\link{H5Group}}s and Datasets (see \code{\link{H5D}})
using subsetting parameters or according class methods.

HDF5 files which have been created or opened through \code{H5File$new()} need 
to be closed afterwards using \code{$close_all()}. \code{$close_all()} not only closes the file itself,
but also all objects that are still open inside it (such as groups or datasets). \code{$flush()} can be used 
to flush unwritten data to an HDF5 file.

HDF5 Files typically contain the following objects:
\describe{
  \item{Groups}{Similar to a file system folder, used to organize HDF5 objects in a hierarchical way, see also \code{\link{H5Group}}}
  \item{Datasets}{Objects to store actual data, see also \code{\link{H5D}}}
  \item{Attributes}{Meta data objects to store extra information about Files, Groups and Datasets, see also \code{\link{H5A}}}
}
}
\section{Methods}{

\describe{
\item{\code{new(filename = NULL, mode = c("a", "r", "r+", "w", "w-", "x"),
  file_create_pl = h5const$H5P_DEFAULT,
  file_access_pl = h5const$H5P_DEFAULT, id = NULL)}}{

Opens or creates a new HDF5 File

\strong{Parameters}
\describe{
\item{filename}{Name of the file}
\item{mode}{How to open it. \code{a} creates a new file or opens an existing one for read/write. \code{r} opens an
existing file for reading, \code{r+} opens an existing file for read/write. \code{w} creates a file, truncating any
existing ones and \code{w-}/\code{x} are synonyms, creating a file and failing if it already exists.}
}}

\item{\code{get_obj_count(types = h5const$H5F_OBJ_ALL)}}{

This function implements the HDF5-API function H5Fget_obj_count.
Please see the documentation at \url{https://www.hdfgroup.org/HDF5/doc/RM/RM_H5F.html#File-GetObjCount} for details.}

\item{\code{get_obj_ids(types = h5const$H5F_OBJ_ALL)}}{

This function implements the HDF5-API function H5Fget_obj_ids.
Please see the documentation at \url{https://www.hdfgroup.org/HDF5/doc/RM/RM_H5F.html#File-GetObjIds} for details.}

\item{\code{get_filesize()}}{

This function implements the HDF5-API function H5Fget_filesize.
Please see the documentation at \url{https://www.hdfgroup.org/HDF5/doc/RM/RM_H5F.html#File-GetFilesize} for details.}

\item{\code{file_info()}}{

This function implements the HDF5-API function H5Fget_info2.
Please see the documentation at \url{https://www.hdfgroup.org/HDF5/doc/RM/RM_H5F.html#File-GetInfo2} for details.
Please note that the returned information differs if HDF5 Version 1.8.16 or HDF5 Version >= 1.10.0 is being used}

\item{\code{get_intent()}}{

This function implements the HDF5-API function H5Fget_intent.
Please see the documentation at \url{https://www.hdfgroup.org/HDF5/doc/RM/RM_H5F.html#File-GetIntent} for details.}

\item{\code{close_all(close_self = TRUE)}}{

Closes the file, flushes it and also closes all open objects that are still open in it. This is the recommended way of
closing any file. If not all objects in a file are closed, the file remains open and cannot be re-opened the regular way.}

\item{\code{print(..., max.attributes = 10, max.listing = 10)}}{

Prints information for the file

\strong{Parameters}
\describe{
\item{max.attributes}{Maximum number of attribute names to print}
\item{max.listing}{Maximum number of ls-items to print}
\item{...}{ignored}
}}

\item{\code{open(name, link_access_pl = h5const$H5P_DEFAULT,
  dataset_access_pl = h5const$H5P_DEFAULT,
  type_access_pl = h5const$H5P_DEFAULT)}}{

Opens groups, datasets or types using the appropriate HDF5-API functions. Please see the documentation at
\url{https://www.hdfgroup.org/HDF5/doc/RM/RM_H5D.html#Dataset-Open} for datasets, 
\url{https://www.hdfgroup.org/HDF5/doc/RM/RM_H5O.html#Object-Open} for types and 
\url{https://www.hdfgroup.org/HDF5/doc/RM/RM_H5O.html#Object-Open} for general objects.}

\item{\code{open_by_idx(n, group_name = ".",
  index_type = h5const$H5_INDEX_NAME,
  order = h5const$H5_ITER_NATIVE,
  link_access_pl = h5const$H5P_DEFAULT)}}{

This function implements the HDF5-API function H5Oopen_by_idx.
Please see the documentation at \url{https://www.hdfgroup.org/HDF5/doc/RM/RM_H5O.html#Object-OpenByIdx} for details.}

\item{\code{ls(recursive = FALSE, detailed = FALSE,
  index_type = h5const$H5_INDEX_NAME,
  order = h5const$H5_ITER_NATIVE,
  link_access_pl = h5const$H5P_DEFAULT,
  dataset_access_pl = h5const$H5P_DEFAULT,
  type_access_pl = h5const$H5P_DEFAULT)}}{

Returns the contents of a file or group as a data.frame.}

\item{\code{exists(name, link_access_pl = h5const$H5P_DEFAULT)}}{

This function implements the HDF5-API function H5Lexists.
Please see the documentation at \url{https://www.hdfgroup.org/HDF5/doc/RM/RM_H5L.html#Link-Exists} for details.}

\item{\code{path_valid(path, check_object_valid = TRUE)}}{

This function implements the HDF5-API function H5LTpath_valid.
Please see the documentation at \url{https://support.hdfgroup.org/HDF5/doc/HL/RM_H5LT.html#H5LTpath_valid} for details.}

\item{\code{link(obj, new_link_name, link_create_pl = h5const$H5P_DEFAULT,
  link_access_pl = h5const$H5P_DEFAULT)}}{

This function implements the HDF5-API function H5Olink.
Please see the documentation at \url{https://www.hdfgroup.org/HDF5/doc/RM/RM_H5O.html#Object-Link} for details.}

\item{\code{obj_copy_to(dst_loc, dst_name, src_name,
  object_copy_pl = h5const$H5P_DEFAULT,
  link_create_pl = h5const$H5P_DEFAULT)}}{

This function implements the HDF5-API function H5Ocopy.
Please see the documentation at \url{https://www.hdfgroup.org/HDF5/doc/RM/RM_H5O.html#Object-Copy} for details.}

\item{\code{obj_copy_from(src_loc, src_name, dst_name,
  object_copy_pl = h5const$H5P_DEFAULT,
  link_create_pl = h5const$H5P_DEFAULT)}}{

This function implements the HDF5-API function H5Ocopy.
Please see the documentation at \url{https://www.hdfgroup.org/HDF5/doc/RM/RM_H5O.html#Object-Copy} for details.}

\item{\code{obj_info_by_idx(n, group_name = ".",
  index_field = h5const$H5_INDEX_NAME,
  order = h5const$H5_ITER_NATIVE, remove_internal_use_only = TRUE)}}{

This function implements the HDF5-API function H5Oget_info_by_idx.
Please see the documentation at \url{https://www.hdfgroup.org/HDF5/doc/RM/RM_H5O.html#Object-GetInfoByIdx} for details.}

\item{\code{obj_info_by_name(object_name, remove_internal_use_only = TRUE)}}{

This function implements the HDF5-API function H5Oget_info_by_name.
Please see the documentation at \url{https://www.hdfgroup.org/HDF5/doc/RM/RM_H5O.html#Object-GetInfoByName} for details.}

\item{\code{group_info()}}{

This function implements the HDF5-API function H5Gget_info.
Please see the documentation at \url{https://www.hdfgroup.org/HDF5/doc/RM/RM_H5G.html#Group-GetInfo} for details.}

\item{\code{group_info_by_name(name, link_access_pl = h5const$H5P_DEFAULT)}}{

This function implements the HDF5-API function H5Gget_info_by_name.
Please see the documentation at \url{https://www.hdfgroup.org/HDF5/doc/RM/RM_H5G.html#Group-GetInfoByName} for details.}

\item{\code{group_info_by_idx(n, group_name = ".",
  index_field = h5const$H5_INDEX_NAME,
  order = h5const$H5_ITER_NATIVE,
  link_access_pl = h5const$H5P_DEFAULT)}}{

This function implements the HDF5-API function H5Gget_info_by_idx.
Please see the documentation at \url{https://www.hdfgroup.org/HDF5/doc/RM/RM_H5G.html#Group-GetInfoByIdx} for details.}

\item{\code{create_group(name, link_create_pl = h5const$H5P_DEFAULT,
  group_create_pl = h5const$H5P_DEFAULT,
  group_access_pl = h5const$H5P_DEFAULT)}}{

This function implements the HDF5-API function H5Gcreate2 and H5Gcreate_anon (if name is NULL). Please see the documentation at
\url{https://www.hdfgroup.org/HDF5/doc/RM/RM_H5G.html#Group-Create2} for regular groups and
\url{https://www.hdfgroup.org/HDF5/doc/RM/RM_H5G.html#Group-CreateAnon} for anonymous groups for details.}

\item{\code{create_dataset(name, robj = NULL, dtype = NULL, space = NULL,
  dims = NULL, chunk_dims = "auto", gzip_level = 4,
  link_create_pl = h5const$H5P_DEFAULT,
  dataset_create_pl = h5const$H5P_DEFAULT,
  dataset_access_pl = h5const$H5P_DEFAULT)}}{

This function is the main interface to create a new dataset. Its parameters allow for customization of the default
behavior, i.e. in order to get a specific datatype, a certain chunk size or dataset dimensionality.
Also note that this function implements the HDF5-API function H5Dcreate2 and H5Dcreate_anon (if name is NULL). Please see the documentation at
\url{https://www.hdfgroup.org/HDF5/doc/RM/RM_H5D.html#Dataset-Create2} for regular groups and
\url{https://www.hdfgroup.org/HDF5/doc/RM/RM_H5D.html#Dataset-CreateAnon} for anonymous groups for details.

\strong{Parameters}
\describe{
\item{name}{The name of the new dataset. If missing, an anonymous dataset is created}
\item{robj}{An R-object to take as a template for creating the dataset. Either \code{robj} or both \code{dtype} and {space}
have to be provided}
\item{dtype}{The datatype to use for the creation of the object. Can be null if \code{robj} is given.}
\item{space}{The space to use for the object creation. Can be null if \code{robj} is given. Otherwise an object of type \code{H5S} which specifies the dimensions of the dataset.}
\item{dims}{Dimension of the new dataset; used if \code{space} is \code{NULL}. overwrite the dimension guessed from \code{robj}
if \code{robj} is given.}
\item{chunk_dims}{Size of the chunk. Has to have the same length as the dataset dimension. If \code{"auto"}
then the size of each chunk is estimated so that each chunk is roughly as large in bytes as the value in
the \code{hdf5r.chunk_size} option. See also \code{\link{guess_chunks}} for a more detailed explanation.
If set to \code{NULL}, then no chunking is used, unless explicitly set in \code{dataset_create_pl}.}
\item{gzip_level}{Only if \code{chunk_dims} is not null. If given, then the \code{dataset_create_pl} is set to enable zipping
at the level given here. If set to NULL, then gzip is not set (but could be set otherwise in \code{dataset_create_pl}}
\item{link_create_pl}{Link creation property list. See \code{\link{H5P_LINK_CREATE}}}
\item{dataset_create_pl}{Dataset creation property list. See \code{\link{H5P_DATASET_CREATE}}}
\item{dataset_access_pl}{Dataset access property list. See \code{\link{H5P_DATASET_ACCESS}}}
}}

\item{\code{commit(name, dtype, link_create_pl = h5const$H5P_DEFAULT,
  type_create_pl = h5const$H5P_DEFAULT,
  type_access_pl = h5const$H5P_DEFAULT)}}{

This function implements the HDF5-API function H5Tcommit2.
Please see the documentation at \url{https://www.hdfgroup.org/HDF5/doc/RM/RM_H5T.html#Datatype-Commit2} for details.}

\item{\code{link_create_hard(obj_loc, obj_name, link_name,
  link_create_pl = h5const$H5P_DEFAULT,
  link_access_pl = h5const$H5P_DEFAULT)}}{

This function implements the HDF5-API function H5Lcreate_hard.
Please see the documentation at \url{https://www.hdfgroup.org/HDF5/doc/RM/RM_H5L.html#Link-CreateHard} for details.}

\item{\code{link_create_soft(target_path, link_name,
  link_create_pl = h5const$H5P_DEFAULT,
  link_access_pl = h5const$H5P_DEFAULT)}}{

This function implements the HDF5-API function H5Lcreate_soft.
Please see the documentation at \url{https://www.hdfgroup.org/HDF5/doc/RM/RM_H5L.html#Link-CreateSoft} for details.}

\item{\code{link_create_external(target_filename, target_obj_name, link_name,
  link_create_pl = h5const$H5P_DEFAULT,
  link_access_pl = h5const$H5P_DEFAULT)}}{

This function implements the HDF5-API function H5Lcreate_external.
Please see the documentation at \url{https://www.hdfgroup.org/HDF5/doc/RM/RM_H5L.html#Link-CreateExternal} for details.}

\item{\code{link_exists(name, link_access_pl = h5const$H5P_DEFAULT)}}{

This function implements the HDF5-API function H5Lexists.
Please see the documentation at \url{https://www.hdfgroup.org/HDF5/doc/RM/RM_H5L.html#Link-Exists} for details.}

\item{\code{link_move_from(src_loc, src_name, dst_name,
  link_create_pl = h5const$H5P_DEFAULT,
  link_access_pl = h5const$H5P_DEFAULT)}}{

This function implements the HDF5-API function H5Lmove.
Please see the documentation at \url{https://www.hdfgroup.org/HDF5/doc/RM/RM_H5L.html#Link-Move} for details.}

\item{\code{link_move_to(dst_loc, dst_name, src_name,
  link_create_pl = h5const$H5P_DEFAULT,
  link_access_pl = h5const$H5P_DEFAULT)}}{

This function implements the HDF5-API function H5Lmove.
Please see the documentation at \url{https://www.hdfgroup.org/HDF5/doc/RM/RM_H5L.html#Link-Move} for details.}

\item{\code{link_copy_from(src_loc, src_name, dst_name,
  link_create_pl = h5const$H5P_DEFAULT,
  link_access_pl = h5const$H5P_DEFAULT)}}{

This function implements the HDF5-API function H5Lcopy.
Please see the documentation at \url{https://www.hdfgroup.org/HDF5/doc/RM/RM_H5L.html#Link-Copy} for details.}

\item{\code{link_copy_to(dst_loc, dst_name, src_name,
  link_create_pl = h5const$H5P_DEFAULT,
  link_access_pl = h5const$H5P_DEFAULT)}}{

This function implements the HDF5-API function H5Lcopy.
Please see the documentation at \url{https://www.hdfgroup.org/HDF5/doc/RM/RM_H5L.html#Link-Copy} for details.}

\item{\code{link_delete(name, link_access_pl = h5const$H5P_DEFAULT)}}{

This function implements the HDF5-API function H5Ldelete.
Please see the documentation at \url{https://www.hdfgroup.org/HDF5/doc/RM/RM_H5L.html#Link-Delete} for details.}

\item{\code{link_delete_by_idx(n, group_name = ".",
  index_field = h5const$H5_INDEX_NAME,
  order = h5const$H5_ITER_NATIVE,
  link_access_pl = h5const$H5P_DEFAULT)}}{

This function implements the HDF5-API function H5Ldelete_by_idx.
Please see the documentation at \url{https://www.hdfgroup.org/HDF5/doc/RM/RM_H5L.html#Link-DeleteByIdx} for details.}

\item{\code{link_info(name, link_access_pl = h5const$H5P_DEFAULT)}}{

This function implements the HDF5-API function H5Lget_info.
Please see the documentation at \url{https://www.hdfgroup.org/HDF5/doc/RM/RM_H5L.html#Link-GetInfo} for details.}

\item{\code{link_info_by_idx(n, group_name = ".",
  index_field = h5const$H5_INDEX_NAME,
  order = h5const$H5_ITER_NATIVE,
  link_access_pl = h5const$H5P_DEFAULT)}}{

This function implements the HDF5-API function H5Lget_info_by_idx.
Please see the documentation at \url{https://www.hdfgroup.org/HDF5/doc/RM/RM_H5L.html#Link-GetInfoByIdx} for details.}

\item{\code{link_value(name, link_access_pl = h5const$H5P_DEFAULT)}}{

This function implements the HDF5-API function H5Lget_val.
Please see the documentation at \url{https://www.hdfgroup.org/HDF5/doc/RM/RM_H5L.html#Link-GetVal} for details.}

\item{\code{link_value_by_idx(n, group_name = ".",
  index_field = h5const$H5_INDEX_NAME,
  order = h5const$H5_ITER_NATIVE,
  link_access_pl = h5const$H5P_DEFAULT)}}{

This function implements the HDF5-API function H5Lget_val_by_idx.
Please see the documentation at \url{https://www.hdfgroup.org/HDF5/doc/RM/RM_H5L.html#Link-GetValByIdx} for details.}

\item{\code{link_name_by_idx(n, group_name, idx_type = h5const$H5_INDEX_NAME,
  order = h5const$H5_ITER_NATIVE,
  link_access_pl = h5const$H5P_DEFAULT)}}{

This function implements the HDF5-API function H5Lget_name_by_idx.
Please see the documentation at \url{https://www.hdfgroup.org/HDF5/doc/RM/RM_H5L.html#Link-GetNameByIdx} for details.}

\item{\code{mount(name, child)}}{

This function implements the HDF5-API function H5Fmount.
Please see the documentation at \url{https://www.hdfgroup.org/HDF5/doc/RM/RM_H5F.html#File-Mount} for details.}

\item{\code{unmount(name)}}{

This function implements the HDF5-API function H5Funmount.
Please see the documentation at \url{https://www.hdfgroup.org/HDF5/doc/RM/RM_H5F.html#File-Unmount} for details.}

\item{\code{create_reference(name = ".", space = NULL)}}{

This function implements the HDF5-API function H5Rcreate. If \code{space=NULL} then a \code{H5R_OBJECT} reference
is created, otherwise a \code{H5R_DATASET_REGION} reference
Please see the documentation at \url{https://www.hdfgroup.org/HDF5/doc/RM/RM_H5R.html#Reference-Create} for details.}

\item{\code{obj_info(remove_internal_use_only = TRUE)}}{

This function implements the HDF5-API function H5Oget_info.
Please see the documentation at \url{https://www.hdfgroup.org/HDF5/doc/RM/RM_H5O.html#Object-GetInfo} for details.}

\item{\code{get_obj_name()}}{

This function implements the HDF5-API function H5Iget_name.
Please see the documentation at \url{https://www.hdfgroup.org/HDF5/doc/RM/RM_H5I.html#Identify-GetName} for details.}

\item{\code{create_attr(attr_name, robj = NULL, dtype = NULL, space = NULL)}}{

This function implements the HDF5-API function H5Acreate2.
Please see the documentation at \url{https://www.hdfgroup.org/HDF5/doc/RM/RM_H5A.html#Annot-Create2} for details.}

\item{\code{attr_open(attr_name)}}{

This function implements the HDF5-API function H5Aopen.
Please see the documentation at \url{https://www.hdfgroup.org/HDF5/doc/RM/RM_H5A.html#Annot-Open} for details.}

\item{\code{create_attr_by_name(attr_name, obj_name, robj = NULL,
  dtype = NULL, space = NULL,
  link_access_pl = h5const$H5P_DEFAULT)}}{

This function implements the HDF5-API function H5Acreate_by_name.
Please see the documentation at \url{https://www.hdfgroup.org/HDF5/doc/RM/RM_H5A.html#Annot-CreateByName} for details.}

\item{\code{attr_open_by_name(attr_name, obj_name,
  link_access_pl = h5const$H5P_DEFAULT)}}{

This function implements the HDF5-API function H5Aopen_by_name.
Please see the documentation at \url{https://www.hdfgroup.org/HDF5/doc/RM/RM_H5A.html#Annot-OpenByName} for details.}

\item{\code{attr_open_by_idx(n, obj_name, idx_type = h5const$H5_INDEX_NAME,
  order = h5const$H5_ITER_NATIVE,
  link_access_pl = h5const$H5P_DEFAULT)}}{

This function implements the HDF5-API function H5Aopen_by_idx.
Please see the documentation at \url{https://www.hdfgroup.org/HDF5/doc/RM/RM_H5A.html#Annot-OpenByIdx} for details.}

\item{\code{attr_exists_by_name(attr_name, obj_name,
  link_access_pl = h5const$H5P_DEFAULT)}}{

This function implements the HDF5-API function H5Aexists_by_name.
Please see the documentation at \url{https://www.hdfgroup.org/HDF5/doc/RM/RM_H5A.html#Annot-ExistsByName} for details.}

\item{\code{attr_exists(attr_name)}}{

This function implements the HDF5-API function H5Aexists.
Please see the documentation at \url{https://www.hdfgroup.org/HDF5/doc/RM/RM_H5A.html#Annot-Exists} for details.}

\item{\code{attr_rename_by_name(old_attr_name, new_attr_name, obj_name,
  link_access_pl = h5const$H5P_DEFAULT)}}{

This function implements the HDF5-API function H5Arename_by_name.
Please see the documentation at \url{https://www.hdfgroup.org/HDF5/doc/RM/RM_H5A.html#Annot-RenameByName} for details.}

\item{\code{attr_rename(old_attr_name, new_attr_name)}}{

This function implements the HDF5-API function H5Arename.
Please see the documentation at \url{https://www.hdfgroup.org/HDF5/doc/RM/RM_H5A.html#Annot-Rename} for details.}

\item{\code{attr_delete(attr_name)}}{

This function implements the HDF5-API function H5Adelete.
Please see the documentation at \url{https://www.hdfgroup.org/HDF5/doc/RM/RM_H5A.html#Annot-Delete} for details.}

\item{\code{attr_delete_by_name(attr_name, obj_name,
  link_access_pl = h5const$H5P_DEFAULT)}}{

This function implements the HDF5-API function H5Adelete_by_name.
Please see the documentation at \url{https://www.hdfgroup.org/HDF5/doc/RM/RM_H5A.html#Annot-DeleteByName} for details.}

\item{\code{attr_delete_by_idx(n, obj_name, idx_type = h5const$H5_INDEX_NAME,
  order = h5const$H5_ITER_NATIVE,
  link_access_pl = h5const$H5P_DEFAULT)}}{

This function implements the HDF5-API function H5Adelete_by_idx.
Please see the documentation at \url{https://www.hdfgroup.org/HDF5/doc/RM/RM_H5A.html#Annot-DeleteByIdx} for details.}

\item{\code{attr_info_by_name(attr_name, obj_name,
  link_access_pl = h5const$H5P_DEFAULT)}}{

This function implements the HDF5-API function H5Aget_info_by_name.
Please see the documentation at \url{https://www.hdfgroup.org/HDF5/doc/RM/RM_H5A.html#Annot-GetInfoByName} for details.}

\item{\code{attr_info_by_idx(n, obj_name, idx_type = h5const$H5_INDEX_NAME,
  order = h5const$H5_ITER_NATIVE,
  link_access_pl = h5const$H5P_DEFAULT)}}{

This function implements the HDF5-API function H5Aget_info_by_idx.
Please see the documentation at \url{https://www.hdfgroup.org/HDF5/doc/RM/RM_H5A.html#Annot-GetInfoByIdx} for details.}

\item{\code{attr_name_by_idx(n, obj_name, idx_type = h5const$H5_INDEX_NAME,
  order = h5const$H5_ITER_NATIVE,
  link_access_pl = h5const$H5P_DEFAULT)}}{

This function implements the HDF5-API function H5Aget_name_by_idx.
Please see the documentation at \url{https://www.hdfgroup.org/HDF5/doc/RM/RM_H5A.html#Annot-GetNameByIdx} for details.}

\item{\code{attr_get_number()}}{

This function implements the HDF5-API function H5Aget_num_attrs.
Please see the documentation at \url{https://support.hdfgroup.org/HDF5/doc/RM/RM_H5A.html#Annot-NumAttrs} for details.}

\item{\code{flush(scope = h5const$H5F_SCOPE_GLOBAL)}}{

This function implements the HDF5-API function H5Fflush.
Please see the documentation at \url{https://www.hdfgroup.org/HDF5/doc/RM/RM_H5F.html#File-Flush} for details.}

\item{\code{get_filename()}}{

This function implements the HDF5-API function H5Fget_name.
Please see the documentation at \url{https://www.hdfgroup.org/HDF5/doc/RM/RM_H5F.html#File-GetName} for details.}

\item{\code{names(link_access_pl = h5const$H5P_DEFAULT)}}{

Returns the names of the items in the group or at the root of the file

\strong{Parameters}
\describe{
\item{link_access_pl}{The link-access property list. See \url{https://www.hdfgroup.org/HDF5/doc/RM/RM_H5P.html} for more detail.}
}}
}}

\section{Extract/List File Contents}{

The following functions are defined to extract HDF5 file contents:
\describe{
  \item{\code{\link{list.groups}}}{List HDF5 groups in file.}
  \item{\code{\link{list.datasets}}}{List HDF5 datasets in file.}
  \item{\code{\link{names}}}{List all items in a file or group (applicable for \code{\link{H5File}} and \code{\link{H5Group}})}
  \item{\code{\link{list.attributes}}}{List Attributes of HDF5 object (file, group or dataset).}
  \item{\code{\link{h5attr_names}}}{Attribute names of an HDF5 object; similar to list.attributes}
}
}

\examples{
# The following examples generates a HDF5 file with the different HDF5 
# Objects and shows its contents:
fname <- tempfile(fileext = ".h5")
file <- H5File$new(fname, mode = "a")
file[["testdataset"]] <- 1:10
h5attr(file, "testattrib") <- LETTERS[1:10]
file$create_group("testgroup")
file[["testgroup/testdataset2"]] <- 1:10
# Show contents of file
file
# Close file and delete
file$close_all()

# The following example shows hdf5 file contents and how to use them to iterate over HDF5 elements:
file <- h5file(fname, mode = "a")
sapply(c("testgroup1", "testgroup2", "testgroup3"), file$create_group)
file[["testgroup1/testset1"]] <- 1:10
file[["testgroup2/testset2"]] <- 11:20
file[["testgroup3/testset3"]] <- 21:30

# Extract first 3 elements from each dataset and combine result to matrix
sapply(list.datasets(file, recursive = TRUE), function(x) file[[x]][1:3])
# Close file
file$close_all()
file.remove(fname)

}
\seealso{
\code{\link{h5file}}
}
\author{
Holger Hoefling, Mario Annau
}
