% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/hdf5-methods.R
\name{h5CreateGroup}
\alias{h5CreateGroup}
\alias{h5CreateGroup.H5Group}
\alias{h5CreateGroup.H5File}
\alias{h5CreateGroup.character}
\title{Create new HDF5 group}
\usage{
h5CreateGroup(x, name, ...)

\method{h5CreateGroup}{H5Group}(x, name, show.warnings = TRUE, ...)

\method{h5CreateGroup}{H5File}(x, name, show.warnings = TRUE, ...)

\method{h5CreateGroup}{character}(x, name, show.warnings = TRUE, ...)
}
\arguments{
\item{x}{An \code{\link[hdf5r]{H5File}}, \code{\link[hdf5r]{H5Group}} or a 
path name of HDF5 file.}

\item{name}{Name of the new HDF5 group. Can be recursive, such as "g/sub_g".}

\item{...}{Arguments passed to \code{H5Group$create_group()}.}

\item{show.warnings}{When the group \code{name} already exists, whether or 
not to show warning messages.}
}
\value{
This is an operation function and no return. Any failure should raise an 
error.
}
\description{
Create new HDF5 group
}
\examples{
tmp.file <- tempfile(fileext = ".h5")
h5CreateFile(tmp.file)

h5CreateGroup(tmp.file, "g1")
h5CreateGroup(tmp.file, "g2/g3")

}
\seealso{
\code{\link[hdf5r]{H5Group}}
}
