/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 * Copyright by The HDF Group.                                               *
 * All rights reserved.                                                      *
 *                                                                           *
 * This file is part of HDF5.  The full HDF5 copyright notice, including     *
 * terms governing use, modification, and redistribution, is contained in    *
 * the LICENSE file, which can be found at the root of the source code       *
 * distribution tree, or in https://www.hdfgroup.org/licenses.               *
 * If you do not have access to either file, you may request a copy from     *
 * help@hdfgroup.org.                                                        *
 * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * */

#include "H5FDmodule.h" 
#define H5FD_TESTING    

#include "H5private.h" 
#include "H5FDpkg.h"   

bool
H5FD__supports_swmr_test(const char *vfd_name)
{
    bool ret_value = false;

    FUNC_ENTER_PACKAGE_NOERR

    if (!vfd_name)
        vfd_name = getenv("HDF5_TEST_DRIVER");

    if (!vfd_name || !strcmp(vfd_name, "") || !strcmp(vfd_name, H5_DEFAULT_VFD_NAME))
        ret_value = true;
    else
        ret_value = !strcmp(vfd_name, "log") || !strcmp(vfd_name, "sec2");

    FUNC_LEAVE_NOAPI(ret_value)
} 
