% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glm_rmap_bhm_approx.R
\name{glm.rmap.bhm.approx}
\alias{glm.rmap.bhm.approx}
\title{Posterior of robust meta-analytic predictive prior (RMAP)}
\usage{
glm.rmap.bhm.approx(samples.bhm, G = NULL, ...)
}
\arguments{
\item{samples.bhm}{a matrix of the samples of regression coefficients from the prior induced by the BHM, output
from the \code{\link[=glm.rmap.bhm]{glm.rmap.bhm()}} function.}

\item{G}{an integer vector giving the numbers of mixtures components (in the mixture approximation to
the BHM) for which the BIC is to be calculated. Defaults to 1:9. See the argument \code{G} in
\code{\link[mclust:Mclust]{?mclust::Mclust}}.}

\item{...}{arguments passed to \code{\link[mclust:Mclust]{mclust::Mclust()}}. See \url{https://mclust-org.github.io/mclust/reference/Mclust.html}.}
}
\value{
The function returns a list giving the parameters estimated from the optimal (according to BIC)
mixture model including the mixing proportions, the estimated mean and covariance matrix for each
mixture component. An object of class \code{Mclust} from the mclust::Mclust() function is also included.
}
\description{
Second step for sampling from the posterior distribution of a GLM using the RMAP by Schmidli et al. (2014) \url{doi:10.1111/biom.12242}.
}
\details{
This function approximates the distribution of the output "beta_pred" from the \code{\link[=glm.rmap.bhm]{glm.rmap.bhm()}} function (i.e.,
samples from the prior induced by the Bayesian hierarchical model (BHM)) by a mixture of multivariate normal
distributions. We use the \code{mclust} package by Scrucca et al. (2023) to implement the mixture approximation.
}
\examples{
\donttest{
  if (instantiate::stan_cmdstan_exists()) {
    data(actg036) ## historical data
    ## take subset for speed purposes
    actg036 = actg036[1:100, ]
    hist_data_list = list(actg036)
    samples_bhm = glm.rmap.bhm(
      formula = outcome ~ scale(age) + race + treatment + scale(cd4),
      family = binomial('logit'),
      hist.data.list = hist_data_list,
      chains = 1, iter_warmup = 1000, iter_sampling = 2000
    )$beta_pred
    glm.rmap.bhm.approx(
      samples.bhm = samples_bhm,
      G = 1:5, verbose = FALSE
    )
  }
}
}
\references{
Scrucca, L., Fraley, C., Murphy, T. B., and Raftery, A. E. (2023). Model-Based Clustering, Classification, and Density Estimation Using mclust in R. Chapman and Hall/CRC. ISBN 978-1032234953. \url{https://mclust-org.github.io/book/}.
}
\seealso{
\code{\link[=glm.rmap.bhm]{glm.rmap.bhm()}} for the first step and \code{\link[=glm.rmap]{glm.rmap()}} for the final step of implementing RMAP.
}
