% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/load_hashmap.R
\name{load_hashmap}
\alias{load_hashmap}
\title{Load Hashmaps}
\usage{
load_hashmap(file)
}
\arguments{
\item{file}{the name of a file previously created by a call to
\code{save_hashmap}.}
}
\value{
A \code{Hashmap} object on success; an error on failure.
}
\description{
\code{load_hashmap} reads a file created by a call to
 \code{\link{save_hashmap}} and returns a \code{Hashmap} object.
}
\details{
The object returned will contain all of the same key-value
 pairs that were present in the original \code{Hashmap} at the time
 \code{save_hashmap} was called, but they are not guaranteed to be
 in the same order, due to rehashing.
}
\examples{
H <- hashmap(sample(letters[1:10]), sample(1:10))
tf <- tempfile()

save_hashmap(H, tf)

H2 <- load_hashmap(tf)
all.equal(
    sort(H$find(H2$keys())),
    sort(H2$values())
)

all.equal(
    H$data.frame(),
    readRDS(tf)
)
}
\seealso{
\code{\link{save_hashmap}}
}
