% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/har_plot.R
\name{har_plot}
\alias{har_plot}
\title{Plot event detection on a time series}
\usage{
har_plot(
  obj,
  serie,
  detection,
  event = NULL,
  mark.cp = TRUE,
  ylim = NULL,
  idx = NULL,
  pointsize = 0.5,
  colors = c("green", "blue", "red", "purple")
)
}
\arguments{
\item{obj}{harbinger detector}

\item{serie}{time series}

\item{detection}{detection}

\item{event}{events}

\item{mark.cp}{show change points}

\item{ylim}{limits for y-axis}

\item{idx}{labels for x observations}

\item{pointsize}{default point size}

\item{colors}{default colors for event detection: green is TP, blue is FN, red is FP, purple means observations that are part of a sequence.}
}
\value{
A time series plot with marked events
}
\description{
It accepts as harbinger, a time series, a data.frame of events, a parameter to mark the detected change points, a threshold for the y-axis and an index for the time series
}
\examples{
library(daltoolbox)

#loading the example database
data(examples_anomalies)

#Using the time series 1
dataset <- examples_anomalies$simple
head(dataset)

# setting up time change point using GARCH
model <- hanr_arima()

# fitting the model
model <- fit(model, dataset$serie)

# making detections
detection <- detect(model, dataset$serie)

# filtering detected events
print(detection[(detection$event),])

# evaluating the detections
evaluation <- evaluate(har_eval_soft(), detection$event, dataset$event)
print(evaluation$confMatrix)

# ploting the results
grf <- har_plot(model, dataset$serie, detection, dataset$event)
plot(grf)
}
