% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hcp_pelt.R
\name{hcp_pelt}
\alias{hcp_pelt}
\title{Pruned exact linear time (PELT) method}
\usage{
hcp_pelt()
}
\value{
\code{hcp_pelt} object
}
\description{
Change-point detection method that focus on identifying multiple exact change points in mean/variance \url{doi:10.1080/01621459.2012.737745}.
It wraps the BinSeg implementation available in the changepoint library.
}
\examples{
library(daltoolbox)

#loading the example database
data(har_examples)

#Using example 6
dataset <- har_examples$example6
head(dataset)

# setting up change point method
model <- hcp_pelt()

# fitting the model
model <- fit(model, dataset$serie)

# execute the detection method
detection <- detect(model, dataset$serie)

# filtering detected events
print(detection[(detection$event),])

}
