% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{com_2025}
\alias{com_2025}
\title{French Communes Table (2025)}
\format{
A data frame with one row per commune and the following columns:
\describe{
\item{TYPECOM}{(chr) Type of commune (4 characters)}
\item{COM}{(chr) Commune code (5 characters)}
\item{REG}{(int) Region code (2 characters)}
\item{DEP}{(chr) Department code (3 characters)}
\item{CTCD}{(chr) Code of the territorial collectivity with departmental powers (4 characters)}
\item{ARR}{(chr) District (arrondissement) code (4 characters)}
\item{TNCC_COM}{(int) Name type indicator (1 character)}
\item{NCC_COM}{(chr) Official name in uppercase (200 characters)}
\item{NCCENR_COM}{(chr) Official name with proper typography (200 characters)}
\item{LIBELLE_COM}{(chr) Official name with article and proper typography (200 characters)}
\item{CAN}{(chr) Canton code (5 characters). For “multi-canton” communes, code ranges from 99 to 90 (pseudo-canton) or 89 to 80 (new communes)}
\item{COMPARENT}{(int) Parent commune code for municipal districts and associated or delegated communes (5 characters)}
}
}
\source{
\url{https://www.insee.fr/fr/statistiques/fichier/8377162/cog_ensemble_2025_csv.zip}
}
\usage{
com_2025
}
\description{
Data for French communes from the INSEE file "v_commune_2025.csv".
}
\keyword{datasets}
