% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lords_attendance_session.R
\name{lords_attendance_session}
\alias{lords_attendance_session}
\alias{hansard_lords_attendance_session}
\title{House of Lords attendance by session}
\usage{
lords_attendance_session(session_id = NULL, extra_args = NULL,
  tidy = TRUE, tidy_style = "snake_case", verbose = TRUE)

hansard_lords_attendance_session(session_id = NULL, extra_args = NULL,
  tidy = TRUE, tidy_style = "snake_case", verbose = TRUE)
}
\arguments{
\item{session_id}{The ID of the House of Lords session. If \code{NULL},
returns a list of all sessions, subject to other parameters.
Defaults to \code{NULL}.}

\item{extra_args}{Additional parameters and queries to pass to API. These
queries must be strings and start with "&". See the
\href{http://explore.data.parliament.uk/}{API documentation}
or the package vignette for more details. Defaults to \code{NULL}.}

\item{tidy}{Logical parameter. If \code{TRUE}, fixes the variable names
in the tibble to remove special characters and superfluous text, and
converts the variable names to a consistent style. Defaults to \code{TRUE}.}

\item{tidy_style}{The style to convert variable names to, if
\code{tidy = TRUE}. Accepts one of \code{'snake_case'}, \code{'camelCase'}
and \code{'period.case'}. Defaults to \code{'snake_case'}.}

\item{verbose}{If \code{TRUE}, returns data to console on the progress
of the API request. Defaults to \code{TRUE}.}
}
\value{
A tibble with details on the lords who attended a given session.
}
\description{
Imports data on House of Lords attendance for each parliamentary session.
Please note that the attendance data is not as tidy as some of the others
that are accessible through this API, and so additional work to prepare
this data in a way that you want may be required.
}
\details{
To return a tibble with all codes for available individual sessions, use
\code{lords_attendance_session(session_id=NULL)}, or use
\code{\link{lords_sessions}} to retrieve codes for a given date range.
Attendance from multiple sessions can be accessed by using \code{lapply}
with the output from \code{\link{lords_sessions}}.

Please note that House of Lords attendance data is not as tidy as some of
the others that are accessible through this API, and so additional work
on the return from the API may be required.

Also note that this API does not appear to have been
updated with data after 2017-01-31.
}
\examples{
\dontrun{
x <- lords_attendance_session(session_id = 706178)

#Returns a list of data frames with details of
attendance for each day of a given vector of sessions.
u <- lords_sessions(start_date='2017-01-01')
m <- lapply(u$about, lords_attendance_session)

}
}
\seealso{
\code{\link{lords_attendance_date}}

\code{\link{lords_sessions}}
}
