% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mp_edms.R
\name{mp_edms}
\alias{mp_edms}
\alias{hansard_mp_edms}
\title{Imports data on early day motions signed, sponsored or primarily sponsored by a given MP.}
\usage{
mp_edms(mp_id = NULL, primary_sponsor = TRUE, sponsor = TRUE,
  signatory = TRUE, full_data = FALSE, start_date = "1900-01-01",
  end_date = Sys.Date(), extra_args = NULL, tidy = TRUE,
  tidy_style = "snake_case")

hansard_mp_edms(mp_id = NULL, primary_sponsor = TRUE, sponsor = FALSE,
  signatory = FALSE, full_data = FALSE, extra_args = NULL,
  start_date = "1900-01-01", end_date = Sys.Date(), tidy = TRUE,
  tidy_style = "snake_case")
}
\arguments{
\item{mp_id}{The ID number of an MP. Required parameter, defaults to NULL. Accepts single IDs in numerical or character format, or a list, data.frame column, etc. If given multiple IDs, the results are combined into a single tibble.}

\item{primary_sponsor}{Includes all early day motions where the given member is the primary sponsor in the tibble. Defaults to TRUE.}

\item{sponsor}{Includes all early day motions where the given member a sponsor (but not the primary sponsor) in the tibble. Defaults to TRUE.}

\item{signatory}{Includes all early day motions signed (but not sponsored or primarily sponsored) by the given member in the tibble. Defaults to TRUE.}

\item{full_data}{If TRUE, returns all available data on the EDMs signed or sponsored by a member. Defaults to FALSE. Note that this can be a very slow process compared to other \code{hansard} functions.}

\item{start_date}{The earliest date to include in the tibble, based on the date the MP signed the EDM. Defaults to '1900-01-01'. Accepts character values in 'YYYY-MM-DD' format, and objects of class Date, POSIXt, POSIXct, POSIXlt or anything else than can be coerced to a date with \code{as.Date()}.}

\item{end_date}{The latest date to include in the tibble, based on the date the MP signed the EDM. Defaults to current system date. Defaults to '1900-01-01'. Accepts character values in 'YYYY-MM-DD' format and objects of class Date, POSIXt, POSIXct, POSIXlt or anything else than can be coerced to a date with \code{as.Date()}.}

\item{extra_args}{Additional parameters to pass to API. Defaults to NULL.}

\item{tidy}{Fix the variable names in the tibble to remove special characters and superfluous text, and converts the variable names to a consistent style. Defaults to TRUE.}

\item{tidy_style}{The style to convert variable names to, if tidy = TRUE. Accepts one of 'snake_case', 'camelCase' and 'period.case'. Defaults to 'snake_case'.}
}
\value{
A tibble with information on the tibbles signed, sponsored and/or primarily sponsored by the given MP.
}
\description{
Imports data on early day motions signed, sponsored or primarily sponsored by a given MP.
}
\examples{
\dontrun{
x <- mp_edms(mp_id=3967, primary_sponsor=TRUE, sponsor = TRUE, signatory=TRUE)

x <- mp_edms(mp_id=3967, primary_sponsor=TRUE, sponsor = TRUE, signatory=FALSE, full_data=TRUE)

}
}
\seealso{
\code{\link{early_day_motions}}
}
\keyword{Day}
\keyword{EDM}
\keyword{Early}
\keyword{Motion}
