% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/research_briefings.R
\name{research_briefings}
\alias{research_briefings}
\title{research_briefings}
\usage{
research_briefings(topic = NULL, subtopic = NULL, type = NULL,
  extra_args = NULL, tidy = TRUE)
}
\arguments{
\item{topic}{The topic of the parliamentary briefing.}

\item{subtopic}{The subtopic of the parliamentary briefing.}

\item{type}{The type of research briefing.}

\item{extra_args}{Additional parameters to pass to API. Defaults to NULL.}

\item{tidy}{Fix the variable names in the data frame to remove extra characters, superfluous text and convert variable names to snake_case. Defaults to TRUE.}
}
\description{
Imports data on  Parliamentary Research Briefings. To see a list of possible topics call \code{\link{research_topics_list}} or \code{\link{research_subtopics_list}} for both topics and subtopics. To see a list of briefing types, call \code{\link{research_types_list}}.
}
\examples{
\dontrun{
x <- research_briefings('Housing and planning')

# Requests can be made using lists created using `research_topics_list`
# and `research_subtopics_list`
x <- research_briefings(topic = research_topics_list[[7]])

x <- research_briefings(subtopic = research_subtopics_list[[7]][10])

# Requests for certain briefing types can also be made using lists
# created with 'research_types_list'.
x <- research_briefings(type = research_types_list[[3]])


}
}
\seealso{
research_topics
}
\keyword{Briefings}
\keyword{Parliamentary}
\keyword{Research}
