% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculate_diversities.R
\name{calculate_diversities}
\alias{calculate_diversities}
\title{Calculate Diversities Indices}
\usage{
calculate_diversities(x, cutoff, control, sample, gene, perc_susc)
}
\arguments{
\item{x}{a \code{data.frame} containing the data.}

\item{cutoff}{value for percent susceptible cutoff. Numeric.}

\item{control}{value used to denote the susceptible control in the \code{gene}
field. Character.}

\item{sample}{field providing the unique identification for each sample being
tested. Character.}

\item{gene}{field providing the gene(s) being tested. Character.}

\item{perc_susc}{field providing the percent susceptible reactions.
Character.}
}
\description{
Calculates pathogen diversity index
}
\examples{
# locate system file for import
Ps <- system.file("extdata", "practice_data_set.csv", package = "hagis")

# import 'practice_data_set.csv'
Ps <- read.csv(Ps)
head(Ps)

# calculate susceptibilities with a 60 \% cutoff value
diversities <- calculate_diversities(x = Ps,
                                     cutoff = 60,
                                     control = "susceptible",
                                     sample = "Isolate",
                                     gene = "Rps",
                                     perc_susc = "perc.susc")

diversities

}
