% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/raw_cf.R
\name{shift.raw_cf}
\alias{shift.raw_cf}
\title{shift a \code{raw_cf} correlation function by 'places' time-slices}
\usage{
shift.raw_cf(cf, places)
}
\arguments{
\item{cf}{\code{raw_cf} container}

\item{places}{Integer (possibly a vector), number of time slices that the correlation function
should be shifted by. Can be positive or negative. This can either
be a single value such that a shift by this many time slices will be
applied to every measurement or it can be a vector of values of the
same length as the number of measurements in \code{cf}. In that case,
a different shift will be applied to each measurement. This is useful
if it is important to preserve the absolute time coordinates of a
correlation function until some time-dependent transformations
have been applied.}
}
\value{
Returns an object of class \code{raw_cf}, shifted compared to the input object.
}
\description{
shift a \code{raw_cf} correlation function by 'places' time-slices
}
\details{
The correlation funtion \eqn{C(t)} is shifted in time to produce:
\deqn{C'(t) = C(t+places)}
using periodic boundary conditions in time.
}
