% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matrixfit.R
\name{matrixModel}
\alias{matrixModel}
\title{Correlator matrix model.}
\usage{
matrixModel(par, t, Time, parind, sign.vec, ov.sign.vec, deltat = 0)
}
\arguments{
\item{par}{Numeric vector: Fit parameters of the model. In an
object of type \code{matrixfit}, this should be located at
\code{$opt.res$par}.}

\item{t}{integer vector: Time of interest.}

\item{Time}{integer: Time extent of the lattice.}

\item{parind}{See \code{\link{matrixfit}}.}

\item{sign.vec}{Numeric vector: Relative sign between forward and
backwards propagating part. A plus makes it cosh, a minus makes it sinh.}

\item{ov.sign.vec}{Numeric vector: Overal sign.}

\item{deltat}{Numeric: time shift.}
}
\value{
Returns a numeric vector with the same length as the input vector \code{t}
containing the model evaluation for these t-values.
}
\description{
Correlator matrix model.
}
\seealso{
\code{\link{matrixfit}}
}
