% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shift_row_values.R
\name{shift_row_values}
\alias{shift_row_values}
\title{Shift row values left or right}
\usage{
shift_row_values(.data, .dir = "left", at = NULL)
}
\arguments{
\item{.data}{a table of data.}

\item{.dir}{the shift direction as a string, one of "left" or "right".}

\item{at}{the row indices at which to shift.}
}
\value{
a data frame.
}
\description{
Shift row values left or right
}
\examples{
library(dplyr)
df <- tibble(
    s = c(NA, 1, NA, NA),
    t = c(NA, NA, 1, NA),
    u = c(NA, NA, 2, 5),
    v = c(5, 1, 9, 2),
    x = c(1, 5, 6, 7),
    y = c(NA, NA, 8, NA),
    z = 1:4
)
df \%>\% shift_row_values()
df \%>\% shift_row_values(at = 1:3)
df \%>\% shift_row_values(at = 1:2, .dir = "right")
}
