% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fd_diagnose.R
\name{fd_diagnose}
\alias{fd_diagnose}
\title{Diagnose fractal dimension}
\usage{
fd_diagnose(data, keep_data = TRUE)
}
\arguments{
\item{data}{Output of \code{\link[=fd]{fd()}} with option keep_data = TRUE.}

\item{keep_data}{Logical. Keep diagnostics data?}
}
\value{
A list with fractal dimension across scales, mean fractal dimension, and sd of fractal dimensions across scales.
}
\description{
Diagnoses fractal dimension variation across neighboring scales.
}
\examples{
fd_data <- fd(horseshoe, lvec = c(0.05, 0.1, 0.2, 0.4), method = "area", keep_data = TRUE)
fd_diagnose(fd_data)
fd_diagnose(fd_data, keep_data = FALSE)

}
