% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict_hIRT.R
\name{predict_hIRT}
\alias{predict_hIRT}
\title{Predicting from Hierarchical IRT Models}
\usage{
predict_hIRT(object, y, x, z)
}
\arguments{
\item{object}{An object of class \code{hIRT}.}

\item{y}{A data frame or matrix of item responses.}

\item{x}{Model matrix, including the intercept term, representing the covariates
used to predict the means.}

\item{z}{Model matrix, including the intercept term, representing the covariates
used to predict the variances.}
}
\value{
A data frame.
 \item{post_mean}{Posterior mean estimates of latent preferences, i.e., \eqn{E[\theta|y,x,z]}}
 \item{post_sd}{Posterior standard deviation estimates of latent preferences, i.e., \eqn{\sqrt{V[\theta|y,x,z]}}}
 \item{prior_mean}{Prior mean estimates of latent preferences, i.e., \eqn{E[\theta|x]}}
 \item{prior_sd}{Prior standard deviation estimates of latent preferences, i.e., \eqn{\sqrt{V[\theta|z]}}}
}
\description{
\code{predict_hIRT} predicts latent preferences for new data (\eqn{y}, \eqn{x}, \eqn{z})
  using a fitted \code{hIRT} object. Both posterior (given \eqn{y}, \eqn{x}, \eqn{z}) and
  prior (given \eqn{x}, \eqn{z}) estimates are returned.
}
\examples{
n <- nrow(nes_econ2008)
n_train <- sample.int(n, 3*n/4)
n_test <- setdiff(1:n, n_train)

nes_econ2008_train <- nes_econ2008[n_train, , drop = FALSE]
nes_econ2008_test <- nes_econ2008[n_test, , drop = FALSE]

y <- nes_econ2008_train[, -(1:3)]
x <- model.matrix( ~ party * educ, nes_econ2008_train)
z <- model.matrix( ~ party, nes_econ2008_train)
mod_train <- hgrm(y, x, z)

y2 <- nes_econ2008_test[, -(1:3)]
x2 <- model.matrix( ~ party * educ, nes_econ2008_test)
z2 <- model.matrix( ~ party, nes_econ2008_test)
preds <- predict_hIRT(mod_train, y2, x2, z2)
summary(preds)

}
