% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checkFrame.R
\name{checkFrame}
\alias{checkFrame}
\title{check input data.frame}
\usage{
checkFrame(df, ignore = NULL, is.df = TRUE, no.char = TRUE, no.ordered = TRUE)
}
\arguments{
\item{df}{data.frame object to evaluate}

\item{ignore}{character vector of column names that should be ignored, if any.}

\item{is.df}{logical. if TRUE, it examines if the 'df' is 'data.frame'}

\item{no.char}{logical. if TRUE, it examines if the 'df' has any columns of class 'character'}

\item{no.ordered}{logical. if TRUE, it examines if the 'df' has any columns of class 'ordered' factors}
}
\value{
nothing
}
\description{
checks the class of the input data.frame, makes sure that
             the specified 'df' is indeed a data.frame and more over,
             there is no column with class 'character' or 'ordered' in the
             data.frame. this function helps you ensure that your data is
             compatible with h2o R package.
}
\examples{
data(cars)

# no error is expected because 'cars' dataset does not
# have 'ordered' or 'character' columns
checkFrame(cars)
}
\author{
E. F. Haghish
}
