% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/permutation_varimp.R
\name{h2o.permutation_importance_plot}
\alias{h2o.permutation_importance_plot}
\title{Plot Permutation Variable Importances.}
\usage{
h2o.permutation_importance_plot(
  object,
  newdata,
  metric = c("AUTO", "AUC", "MAE", "MSE", "RMSE", "logloss", "mean_per_class_error",
    "PR_AUC"),
  n_samples = 10000,
  n_repeats = 1,
  features = NULL,
  seed = -1,
  num_of_features = NULL
)
}
\arguments{
\item{object}{A trained supervised H2O model.}

\item{newdata}{Training frame of the model which is going to be permuted}

\item{metric}{Metric to be used. One of "AUTO", "AUC", "MAE", "MSE", "RMSE", "logloss", "mean_per_class_error",
"PR_AUC".  Defaults to "AUTO".}

\item{n_samples}{Number of samples to be evaluated. Use -1 to use the whole dataset. Defaults to 10 000.}

\item{n_repeats}{Number of repeated evaluations. Defaults to 1.}

\item{features}{Character vector of features to include in the permutation importance. Use NULL to include all.}

\item{seed}{Seed for the random generator. Use -1 to pick a random seed. Defaults to -1.}

\item{num_of_features}{The number of features shown in the plot (default is 10 or all if less than 10).}
}
\value{
H2OTable with variable importance.
}
\description{
This method plots either a bar plot or if n_repeats > 1 a box plot and returns the variable importance table.
}
\examples{
\dontrun{
library(h2o)
h2o.init()
prostate_path <- system.file("extdata", "prostate.csv", package = "h2o")
prostate <- h2o.importFile(prostate_path)
prostate[, 2] <- as.factor(prostate[, 2])
model <- h2o.gbm(x = 3:9, y = 2, training_frame = prostate, distribution = "bernoulli")
h2o.permutation_importance_plot(model, prostate)
}
}
