% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/automl.R
\name{h2o.get_automl}
\alias{h2o.get_automl}
\alias{h2o.getAutoML}
\title{Get an R object that is a subclass of \linkS4class{H2OAutoML}}
\usage{
h2o.get_automl(project_name)

h2o.getAutoML(project_name)
}
\arguments{
\item{project_name}{A string indicating the project_name of the automl instance to retrieve.}
}
\value{
Returns an object that is a subclass of \linkS4class{H2OAutoML}.
}
\description{
Get an R object that is a subclass of \linkS4class{H2OAutoML}
}
\examples{
\dontrun{
library(h2o)
h2o.init()
prostate_path <- system.file("extdata", "prostate.csv", package = "h2o")
prostate <- h2o.importFile(path = prostate_path, header = TRUE)
y <- "CAPSULE"
prostate[,y] <- as.factor(prostate[,y])  #convert to factor for classification
aml <- h2o.automl(y = y, training_frame = prostate, 
                  max_runtime_secs = 30, project_name = "prostate")
aml2 <- h2o.get_automl("prostate")
}
}
