% Generated by roxygen2 (4.0.2): do not edit by hand
\docType{methods}
\name{h2o.var}
\alias{h2o.var}
\alias{var,H2OFrame-method}
\title{Variance of a column.}
\usage{
\S4method{var}{H2OFrame}(x, y = NULL, na.rm = FALSE, use)
}
\arguments{
\item{x}{An \linkS4class{H2OFrame} object.}

\item{y}{\code{NULL} (default) or a column of an \linkS4class{H2OFrame} object. The default is equivalent to y = x (but more efficient).}

\item{na.rm}{\code{logical}. Should missing values be removed?}

\item{use}{An optional character string to be used in the presence of missing values. This must be one of the following strings. "everything", "all.obs", or "complete.obs".}
}
\description{
Obtain the variance of a column of a parsed H2O data object.
}
\examples{
localH2O <- h2o.init()
prosPath <- system.file("extdata", "prostate.csv", package="h2o")
prostate.hex <- h2o.uploadFile(localH2O, path = prosPath)
var(prostate.hex$AGE)
}
\seealso{
\code{\link[stats]{var}} for the base R implementation. \code{\link{h2o.sd}} for standard deviation.
}

