% Generated by roxygen2 (4.0.2): do not edit by hand
\name{h2o.glrm}
\alias{h2o.glrm}
\title{Generalized Low Rank Model}
\usage{
h2o.glrm(training_frame, x, k, destination_key, loading_key,
  transform = c("NONE", "DEMEAN", "DESCALE", "STANDARDIZE", "NORMALIZE"),
  loss = c("L2", "L1", "Huber", "Poisson", "Hinge", "Logistic"),
  regularization_x = c("L2", "L1"), regularization_y = c("L2", "L1"),
  gamma_x = 0, gamma_y = 0, max_iterations = 1000, init_step_size = 1,
  min_step_size = 0.001, init = c("Random", "PlusPlus", "SVD"),
  recover_pca = FALSE, seed)
}
\arguments{
\item{training_frame}{An \linkS4class{H2OFrame} object containing the
variables in the model.}

\item{x}{(Optional) A vector containing the data columns on
which k-means operates.}

\item{k}{The rank of the resulting decomposition. This must be
between 1 and the number of columns in the training frame, inclusive.}

\item{destination_key}{(Optional) The unique hex key assigned to the
resulting model. Automatically generated if none is provided.}

\item{loading_key}{(Optional) The unique hex key assigned to the loading matrix X
in the XY decomposition. Automatically generated if none is provided.}

\item{transform}{A character string that indicates how the training data
should be transformed before running PCA. Possible values are "NONE":
for no transformation, "DEMEAN": for subtracting the mean of each
column, "DESCALE": for dividing by the standard deviation of each
column, "STANDARDIZE": for demeaning and descaling, and "NORMALIZE":
for demeaning and dividing each column by its range (max - min).}

\item{loss}{A character string indicating the loss function. Possible values are
"L2", "L1", "Huber", "Poisson", "Hinge" and "Logistic".}

\item{regularization_x}{A character string indicating the regularization function for
the X matrix. Possible values are "L2" and "L1".}

\item{regularization_y}{A character string indicating the regularization function for
the Y matrix. Possible values are "L2" and "L1".}

\item{gamma_x}{The weight on the X matrix regularization term. For no X regularization,
set this value to zero.}

\item{gamma_y}{The weight on the Y matrix regularization term. For no Y regularization,
set this value to zero.}

\item{max_iterations}{The maximum number of iterations to run the optimization loop.
Each iteration consists of an update of the X matrix, followed by an update
of the Y matrix.}

\item{init_step_size}{Initial step size. Divided by number of columns in the training
frame when calculating the proximal gradient update. The algorithm begins at
init_step_size and decreases the step size at each iteration until a
termination condition is reached.}

\item{min_step_size}{Minimum step size upon which the algorithm is terminated.}

\item{init}{A character string indicating how to select the initial Y matrix.
Possible values are "Random": for initialization to a random array from the
standard normal distribution, "PlusPlus": for initialization using the clusters
from k-means++ initialization, or "SVD": for initialization using the
first k right singular vectors. Additionally, the user may specify the
initial Y as a matrix, data.frame, H2OFrame, or list of vectors.}

\item{recover_pca}{A logical value indicating whether the principal components should
be recovered during post-processing of the generalized low rank decomposition.}

\item{seed}{(Optional) Random seed used to initialize the X and Y matrices.}
}
\description{
Generalized low rank decomposition of a H2O dataset.
}

