% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model.R
\name{GWAS}
\alias{GWAS}
\title{Run a genome-wide association study (GWAS) using the provided model}
\usage{
GWAS(model, snpData, out = "out.log", ..., SNP = NULL,
  startFrom = 1L)
}
\arguments{
\item{model}{an instance of \link[OpenMx:MxModel-class]{MxModel}}

\item{snpData}{the name of the file where the SNP data is stored}

\item{out}{the filename where the results of fitted models shall be written}

\item{...}{Not used.  Forces remaining arguments to be specified by name.}

\item{SNP}{a vector of SNP indices to include in the analysis; NULL is interpreted as all available SNPs}

\item{startFrom}{the index to start from when \code{SNP=NULL}}
}
\value{
The \link[OpenMx:MxModel-class]{MxModel} returned by \link[OpenMx]{mxRun}.
Data and estimates for the last SNP processed will be available for inspection.
}
\description{
Adds a compute plan returned by \link{prepareComputePlan} to the
provided \code{model} and runs it. Once analyses are complete,
load your aggregated results with \link{loadResults}.
}
\examples{
dir <- system.file("extdata", package = "gwsem")
pheno <- data.frame(anxiety=rnorm(500))
m1 <- buildOneItem(pheno, 'anxiety')
GWAS(m1, file.path(dir,"example.pgen"),
     file.path(tempdir(),"out.log"))
}
