% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/family.elliptical.R
\name{family.elliptical}
\alias{family.elliptical}
\alias{Cauchy}
\alias{Cnormal}
\alias{Gstudent}
\alias{Glogis}
\alias{Normal}
\alias{Powerexp}
\alias{Student}
\alias{LogisI}
\alias{LogisII}
\title{Family Objects for Elliptical Models}
\usage{
\method{family}{elliptical}(object, ...)

Normal()

Cauchy()

LogisI()

LogisII()

Student(df = stop("no df argument"))

Powerexp(k = stop("no k argument"))

Glogis(parma = stop("no alpha=alpha(m) or m argument"))

Gstudent(parm = stop("no s or r argument"))

Cnormal(parmt = stop("no epsi or sigma argument"))
}
\arguments{
\item{object}{an object with the result of the fitted elliptical regression model.}

\item{...}{arguments to be used to form the default control argument if it is not supplied directly.}

\item{df}{degrees of freedom.}

\item{k}{shape parameter.}

\item{parma}{parameter vector (alpha, m).}

\item{parm}{parameter vector (s, r) for this distribuition.}

\item{parmt}{parameters vector (epsi, sigma).}
}
\value{
An object of class \dQuote{family} specifying a list with the follows elements:
\item{family}{character: the family name.}
\item{g0, g1, g2, g3, g4, g5}{derived fuctions associated with the distribution family defined.}
\item{df}{degree of freedom for t-Student distribution.}
\item{s, r}{shape parameters for generalized t-Student distribution.}
\item{alpha}{shape parameter for contaminated normal and generalized logistic distributions.}  
\item{mp}{shape parameter for generalized logistic distribution.}
\item{epsi,sigmap}{dispersion parameters for contaminated normal distribution.}
\item{k}{shape parameter for power exponential distribution.}
}
\description{
The family object provide an specify details of the model used by functions such as \code{\link{elliptical}}, \code{\link{gwer}} and \code{\link{gwer.multiscale}}. The distribution functions are necessary to specify the random component of the regression models with elliptical errors.
}
\examples{
data(luzdat)
y <- luzdat$y
x1 <- luzdat$x1 ; x1 <- factor(x1) ; x1 <- C(x1,treatment)
x2 <- luzdat$x2
x3 <- (luzdat$x2)^2
luz <- data.frame(y,x1,x2,x3)
elliptical.fitt <- elliptical(y ~ x1+x2+x3, family = Normal()
,data=luz)
family(elliptical.fitt)
}
\references{
Fang, K. T., Kotz, S. and NG, K. W. (1990, ISBN:9781315897943).
Symmetric Multivariate and Related Distributions. London: Chapman and Hall.
}
\seealso{
\code{\link{elliptical}}, \code{\link{gwer}}
}
\keyword{Elliptical}
\keyword{distributions}
\keyword{models}
