% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R
\name{subset-studies}
\alias{subset-studies}
\alias{[,studies,missing,missing,missing-method}
\alias{[,studies,numeric,missing,missing-method}
\alias{[,studies,character,missing,missing-method}
\title{Subset a studies object}
\usage{
\S4method{[}{studies,missing,missing,missing}(x, i, j, ..., drop = FALSE)

\S4method{[}{studies,numeric,missing,missing}(x, i, j, ..., drop = FALSE)

\S4method{[}{studies,character,missing,missing}(x, i, j, ..., drop = FALSE)
}
\arguments{
\item{x}{A \linkS4class{studies} object.}

\item{i}{Position of the identifier or the name of the identifier itself.}

\item{j}{Not used.}

\item{...}{Additional arguments not used here.}

\item{drop}{Not used.}
}
\value{
A \linkS4class{studies} object.
}
\description{
You can subset \linkS4class{studies} by identifier or by position using the
\code{`[`} operator.
}
\examples{
# Subset a studies object by identifier
studies_ex01['GCST001585']

# Or by its position in table studies
studies_ex01[1]

# Keep all studies except the first
studies_ex01[-1]

}
