% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cut_quartiles.R
\name{cut_quartiles}
\alias{cut_quartiles}
\title{Cut a continuous variable in quartiles}
\usage{
cut_quartiles(x, include.lowest = TRUE, ...)
}
\arguments{
\item{x}{a numeric vector which is to be converted to a factor by cutting.}

\item{include.lowest}{logical, indicating if an \sQuote{x[i]} equal to
    the lowest (or highest, for \code{right = FALSE}) \sQuote{breaks}
    value should be included.}

\item{...}{further arguments passed to \code{\link[base:cut]{base::cut()}}.}
}
\description{
Convenient function to quickly cut a numeric vector into quartiles, i.e. by
applying \code{cut(x, breaks = fivenum(x))}. Variable label is preserved by
\code{cut_quartiles()}.
}
\examples{
mtcars$mpg |> cut_quartiles() |> summary()
}
\keyword{manip}
