% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convert_sf_to_shapes.R
\name{convert_sf_to_shapes}
\alias{convert_sf_to_shapes}
\title{Convert a simple feature object into a \code{shapes} table}
\usage{
convert_sf_to_shapes(sf_shapes, shape_id = NULL, calculate_distance = TRUE)
}
\arguments{
\item{sf_shapes}{A \verb{LINESTRING sf} associating each \code{shape_id}s to a
geometry. This object must use CRS WGS 84 (EPSG code 4326).}

\item{shape_id}{A character vector specifying the \code{shape_id}s to be
converted. If \code{NULL} (the default), all shapes are converted.}

\item{calculate_distance}{A logical. Whether to calculate and populate the
\code{shape_dist_traveled} column. This column is used to describe the distance
along the shape from each one of its points to its first point. Defaults to
\code{TRUE}.}
}
\value{
A \code{data.table} representing a GTFS \code{shapes} table.
}
\description{
Converts a \verb{LINESTRING sf} object into a GTFS \code{shapes} table.
}
\examples{
data_path <- system.file("extdata/spo_gtfs.zip", package = "gtfstools")
gtfs <- read_gtfs(data_path)

# first converting existing shapes table into a sf object
shapes_sf <- convert_shapes_to_sf(gtfs)
head(shapes_sf)

# by default converts all shapes
result <- convert_sf_to_shapes(shapes_sf)
result

# shape_id argument controls which shapes are converted
result <- convert_sf_to_shapes(shapes_sf, shape_id = c("17846", "17847"))
result

# calculate_distance argument controls whether to calculate
# shape_dist_traveled or not
result <- convert_sf_to_shapes(shapes_sf, calculate_distance = TRUE)
result

}
