% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_gtfs.R
\name{read_gtfs}
\alias{read_gtfs}
\title{Read GTFS data into a list of data.tables}
\usage{
read_gtfs(gtfszip)
}
\arguments{
\item{gtfszip}{A zipped GTFS data.}
}
\value{
A list of data.tables, where each index represents the respective GTFS file name.
}
\description{
Read files of a zipped GTFS feed and load them to memory as a list of data.tables.
It will load the following files: "shapes.txt", "stop_times.txt", "stops.txt", "trips.txt",
"agency.txt", "calendar.txt", "routes.txt", and "frequencies.txt", with
this last four being optional. If one of the mandatory files does not exit,
this function will stop with an error message.
}
\examples{
poa <- read_gtfs(system.file("extdata/poa.zip", package = "gtfs2gps"))
}
