% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_gwas_catalog_by_location.R
\name{get_gwas_catalog_by_location}
\alias{get_gwas_catalog_by_location}
\title{Get Gwas Catalog By Location}
\usage{
get_gwas_catalog_by_location(
  start,
  end,
  chromosome,
  page = 0,
  itemsPerPage = getOption("gtexr.itemsPerPage"),
  .verbose = getOption("gtexr.verbose"),
  .return_raw = FALSE
)
}
\arguments{
\item{start}{Integer.}

\item{end}{Integer.}

\item{chromosome}{String. One of "chr1", "chr2", "chr3", "chr4", "chr5",
"chr6", "chr7", "chr8", "chr9", "chr10", "chr11", "chr12", "chr13",
"chr14", "chr15", "chr16", "chr17", "chr18", "chr19", "chr20", "chr21",
"chr22", "chrM", "chrX", "chrY".}

\item{page}{Integer (default = 0).}

\item{itemsPerPage}{Integer (default = 250). Set globally to maximum value
100000 with \code{options(list(gtexr.itemsPerPage = 100000))}.}

\item{.verbose}{Logical. If \code{TRUE} (default), print paging information. Set
to \code{FALSE} globally with \code{options(list(gtexr.verbose = FALSE))}.}

\item{.return_raw}{Logical. If \code{TRUE}, return the raw API JSON response.
Default = \code{FALSE}}
}
\value{
A tibble. Or a list if \code{.return_raw = TRUE}.
}
\description{
Find the GWAS Catalog on a certain chromosome between start and
end locations.

\href{https://gtexportal.org/api/v2/redoc#tag/Reference-Genome-Endpoints/operation/get_gwas_catalog_by_location_api_v2_reference_gwasCatalogByLocation_get}{GTEx API Portal documentation}
}
\examples{
\dontrun{
get_gwas_catalog_by_location(start = 1, end = 10000000, chromosome = "chr1")
}
}
\seealso{
Other Reference Genome Endpoints: 
\code{\link{get_exons}()},
\code{\link{get_gene_search}()},
\code{\link{get_genes}()},
\code{\link{get_genomic_features}()},
\code{\link{get_neighbor_gene}()},
\code{\link{get_transcripts}()}
}
\concept{Reference Genome Endpoints}
