% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_functional_annotation.R
\name{get_functional_annotation}
\alias{get_functional_annotation}
\title{Get Functional Annotation}
\usage{
get_functional_annotation(
  datasetId = "gtex_v8",
  chromosome,
  start,
  end,
  page = 0,
  itemsPerPage = getOption("gtexr.itemsPerPage"),
  .verbose = getOption("gtexr.verbose"),
  .return_raw = FALSE
)
}
\arguments{
\item{datasetId}{String. Unique identifier of a dataset. Usually includes a
data source and data release. Options: "gtex_v8", "gtex_snrnaseq_pilot".}

\item{chromosome}{String. One of "chr1", "chr2", "chr3", "chr4", "chr5",
"chr6", "chr7", "chr8", "chr9", "chr10", "chr11", "chr12", "chr13",
"chr14", "chr15", "chr16", "chr17", "chr18", "chr19", "chr20", "chr21",
"chr22", "chrM", "chrX", "chrY".}

\item{start}{Integer.}

\item{end}{Integer.}

\item{page}{Integer (default = 0).}

\item{itemsPerPage}{Integer (default = 250). Set globally to maximum value
100000 with \code{options(list(gtexr.itemsPerPage = 100000))}.}

\item{.verbose}{Logical. If \code{TRUE} (default), print paging information. Set
to \code{FALSE} globally with \code{options(list(gtexr.verbose = FALSE))}.}

\item{.return_raw}{Logical. If \code{TRUE}, return the raw API JSON response.
Default = \code{FALSE}}
}
\value{
A tibble. Or a list if \code{.return_raw = TRUE}.
}
\description{
This endpoint retrieves the functional annotation of a certain
chromosome location. Default to most recent dataset release.

\href{https://gtexportal.org/api/v2/redoc#tag/Datasets-Endpoints/operation/get_full_get_collapsed_gene_model_exon_api_v2_dataset_fullCollapsedGeneModelExon_get}{GTEx Portal API documentation}
}
\examples{
\dontrun{
get_functional_annotation(chromosome = "chr1", start = 192168000, end = 192169000)
}
}
\seealso{
Other Datasets Endpoints: 
\code{\link{get_annotation}()},
\code{\link{get_collapsed_gene_model_exon}()},
\code{\link{get_downloads_page_data}()},
\code{\link{get_file_list}()},
\code{\link{get_full_get_collapsed_gene_model_exon}()},
\code{\link{get_linkage_disequilibrium_by_variant_data}()},
\code{\link{get_linkage_disequilibrium_data}()},
\code{\link{get_sample_datasets}()},
\code{\link{get_subject}()},
\code{\link{get_tissue_site_detail}()},
\code{\link{get_variant}()},
\code{\link{get_variant_by_location}()}
}
\concept{Datasets Endpoints}
