% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opts.R
\name{opt_row_striping}
\alias{opt_row_striping}
\title{Option to add or remove row striping}
\usage{
opt_row_striping(data, row_striping = TRUE)
}
\arguments{
\item{data}{A table object that is created using the \code{\link[=gt]{gt()}} function.}

\item{row_striping}{A logical value to indicate whether row striping should
be added or removed.}
}
\value{
An object of class \code{gt_tbl}.
}
\description{
By default, a \strong{gt} table does not have row striping enabled. However, this
function allows us to easily enable or disable striped rows in the table
body. This function serves as a convenient shortcut for
\verb{<gt_tbl> \%>\% tab_options(row.striping.include_table_body = TRUE|FALSE)}.
}
\section{Examples}{


Use \code{\link{exibble}} to create a \strong{gt} table with a number of table parts added.
Next, we add row striping to every second row with the \code{opt_row_striping()}
function.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{exibble \%>\%
  gt(rowname_col = "row", groupname_col = "group") \%>\%
  summary_rows(
    groups = "grp_a",
    columns = c(num, currency),
    fns = list(
      min = ~min(., na.rm = TRUE),
      max = ~max(., na.rm = TRUE)
    )) \%>\%
  grand_summary_rows(
    columns = currency,
    fns = list(
      total = ~sum(., na.rm = TRUE)
    )) \%>\%
  tab_source_note(source_note = "This is a source note.") \%>\%
  tab_footnote(
    footnote = "This is a footnote.",
    locations = cells_body(columns = 1, rows = 1)
  ) \%>\%
  tab_header(
    title = "The title of the table",
    subtitle = "The table's subtitle"
  ) \%>\%
  opt_row_striping()
}\if{html}{\out{</div>}}

\if{html}{\out{
<img src="https://raw.githubusercontent.com/rstudio/gt/master/images/man_opt_row_striping_1.png" style="width:100\%;">
}}
}

\section{Function ID}{

9-2
}

\seealso{
Other Table Option Functions: 
\code{\link{opt_align_table_header}()},
\code{\link{opt_all_caps}()},
\code{\link{opt_css}()},
\code{\link{opt_footnote_marks}()},
\code{\link{opt_horizontal_padding}()},
\code{\link{opt_table_font}()},
\code{\link{opt_table_lines}()},
\code{\link{opt_table_outline}()},
\code{\link{opt_vertical_padding}()}
}
\concept{Table Option Functions}
