% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opts.R
\name{opt_interactive}
\alias{opt_interactive}
\title{Option to put interactive elements in an HTML table}
\usage{
opt_interactive(
  data,
  active = TRUE,
  use_pagination = TRUE,
  use_pagination_info = TRUE,
  use_sorting = TRUE,
  use_search = FALSE,
  use_filters = FALSE,
  use_resizers = FALSE,
  use_highlight = FALSE,
  use_compact_mode = FALSE,
  use_text_wrapping = TRUE,
  use_page_size_select = FALSE,
  page_size_default = 10,
  page_size_values = c(10, 25, 50, 100),
  pagination_type = c("numbers", "jump", "simple")
)
}
\arguments{
\item{data}{\emph{The gt table data object}

\verb{obj:<gt_tbl>} // \strong{required}

This is the \strong{gt} table object that is commonly created through use of the
\code{\link[=gt]{gt()}} function.}

\item{active}{\emph{Display interactive HTML table}

\verb{scalar<logical>} // \emph{default:} \code{TRUE}

The \code{active} option will either enable or disable interactive features for
an HTML table. The individual features of an interactive HTML table are
controlled by the other options.}

\item{use_pagination}{\emph{Display pagination controls}

\verb{scalar<logical>} // \emph{default:} \code{TRUE}

This is the option for using pagination controls (below the table body). By
default, this is \code{TRUE} and it will allow the use to page through table
content.}

\item{use_pagination_info}{\emph{Display pagination info}

\verb{scalar<logical>} // \emph{default:} \code{TRUE}

If \code{use_pagination} is \code{TRUE} then the \code{use_pagination_info} option can be
used to display informational text regarding the current page view (this is
set to \code{TRUE} by default).}

\item{use_sorting}{\emph{Provide column sorting controls}

\verb{scalar<logical>} // \emph{default:} \code{TRUE}

This option provides controls for sorting column values. By default, this
is \code{TRUE}.}

\item{use_search}{\emph{Provide a global search field}

\verb{scalar<logical>} // \emph{default:} \code{FALSE}

The \code{use_search} option places a search field for globally filtering rows
to the requested content. By default, this is \code{FALSE}.}

\item{use_filters}{\emph{Display filtering fields}

\verb{scalar<logical>} // \emph{default:} \code{FALSE}

The \code{use_filters} option places search fields below each column header and
allows for filtering by column. By default, this is \code{FALSE}.}

\item{use_resizers}{\emph{Allow column resizing}

\verb{scalar<logical>} // \emph{default:} \code{FALSE}

This option allows for the interactive resizing of columns. By default,
this is \code{FALSE}.}

\item{use_highlight}{\emph{Enable row highlighting on hover}

\verb{scalar<logical>} // \emph{default:} \code{FALSE}

The \code{use_highlight} option highlights individual rows upon hover. By
default, this is \code{FALSE}.}

\item{use_compact_mode}{\emph{Use compact mode}

\verb{scalar<logical>} // \emph{default:} \code{FALSE}

To reduce vertical padding and thus make the table consume less vertical
space the \code{use_compact_mode} option can be used. By default, this is
\code{FALSE}.}

\item{use_text_wrapping}{\emph{Use text wrapping}

\verb{scalar<logical>} // \emph{default:} \code{TRUE}

The \code{use_text_wrapping} option controls whether text wrapping occurs
throughout the table. This is \code{TRUE} by default and with that text will be
wrapped to multiple lines. If \code{FALSE}, text will be truncated to a single
line.}

\item{use_page_size_select}{\emph{Allow for page size selection}

\verb{scalar<logical>} // \emph{default:} \code{FALSE}

The \code{use_page_size_select} option lets us display a dropdown menu for the
number of rows to show per page of data.}

\item{page_size_default}{\emph{Change the default page size}

\verb{scalar<numeric|integer>} // \emph{default:} \code{10}

The default page size (initially set as \code{10}) can be modified with
\code{page_size_default} and this works whether or not \code{use_page_size_select} is
set to \code{TRUE}.}

\item{page_size_values}{\emph{Set of page-size values}

\verb{vector<numeric|integer>} // \emph{default:} \code{c(10, 25, 50, 100)}

By default, this is the vector \code{c(10, 25, 50, 100)} which corresponds to
options for \code{10}, \code{25}, \code{50}, and \code{100} rows of data per page. To modify
these page-size options, provide a numeric vector to \code{page_size_values}.}

\item{pagination_type}{\emph{Change pagination mode}

\verb{scalar<character>} // \emph{default:} \code{"numbers"}

When using pagination the \code{pagination_type} option lets us select between
one of three options for the layout of pagination controls. The default is
\code{"numbers"}, where a series of page-number buttons is presented along with
'previous' and 'next' buttons. The \code{"jump"} option provides an input field
with a stepper for the page number. With \code{"simple"}, only the 'previous'
and 'next' buttons are displayed.}
}
\value{
An object of class \code{gt_tbl}.
}
\description{
By default, a \strong{gt} table rendered as HTML will essentially be a 'static'
table. However, we can make it 'interactive' and configure those interactive
HTML options through the \code{opt_interactive()} function. Making an HTML table
interactive entails the enabling of controls for pagination, global search,
filtering, sorting, and more.

This function serves as a shortcut for setting the following options in
\code{\link[=tab_options]{tab_options()}}:
\itemize{
\item \code{ihtml.active}
\item \code{ihtml.use_pagination}
\item \code{ihtml.use_pagination_info}
\item \code{ihtml.use_sorting}
\item \code{ihtml.use_search}
\item \code{ihtml.use_filters}
\item \code{ihtml.use_resizers}
\item \code{ihtml.use_highlight}
\item \code{ihtml.use_compact_mode}
\item \code{ihtml.use_page_size_select}
\item \code{ihtml.page_size_default}
\item \code{ihtml.page_size_values}
\item \code{ihtml.pagination_type}
}
}
\section{Examples}{


Use select columns from the \code{\link{towny}} dataset to create a \strong{gt} table with a
header (through \code{\link[=tab_header]{tab_header()}}) and a source note (through
\code{\link[=tab_source_note]{tab_source_note()}}). Next, we will add interactive HTML features (and
otherwise activate interactive HTML mode) through \code{opt_interactive()}. It'll
just be the default set of interactive options.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{towny |>
  dplyr::select(name, census_div, starts_with("population")) |>
  gt() |>
  fmt_integer() |>
  cols_label_with(fn = function(x) sub("population_", "", x)) |>
  cols_width(
    name ~ px(200),
    census_div ~ px(200)
  ) |>
  tab_header(
    title = "Populations of Municipalities",
    subtitle = "Census values from 1996 to 2021."
  ) |>
  tab_source_note(source_note = md("Data taken from the `towny` dataset.")) |>
  opt_interactive()
}\if{html}{\out{</div>}}

\if{html}{\out{
<img src="https://raw.githubusercontent.com/rstudio/gt/master/images/man_opt_interactive_1.png" alt="This image of a table was generated from the first code example in the `opt_interactive()` help file." style="width:100\%;">
}}

Interactive tables can have styled body cells. Here, we use the \code{\link{gtcars}}
dataset to create an interactive \strong{gt} table. Using \code{\link[=tab_style]{tab_style()}} and
\code{\link[=data_color]{data_color()}} we can flexibly style body cells throughout the table.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{gtcars |>
  gt() |>
  cols_width(everything() ~ px(130)) |>
  tab_style(
    style = cell_fill(color = "gray95"),
    locations = cells_body(columns = c(mfr, model))
  ) |>
  data_color(
    columns = c(starts_with("hp"), starts_with("trq")),
    method = "numeric",
    palette = "viridis"
  ) |>
  cols_hide(columns = trim) |>
  opt_interactive()
}\if{html}{\out{</div>}}

\if{html}{\out{
<img src="https://raw.githubusercontent.com/rstudio/gt/master/images/man_opt_interactive_2.png" alt="This image of a table was generated from the second code example in the `opt_interactive()` help file." style="width:100\%;">
}}
}

\section{Function ID}{

10-2
}

\section{Function Introduced}{

\code{v0.9.0} (Mar 31, 2023)
}

\seealso{
Other table option functions: 
\code{\link{opt_align_table_header}()},
\code{\link{opt_all_caps}()},
\code{\link{opt_css}()},
\code{\link{opt_footnote_marks}()},
\code{\link{opt_footnote_spec}()},
\code{\link{opt_horizontal_padding}()},
\code{\link{opt_row_striping}()},
\code{\link{opt_stylize}()},
\code{\link{opt_table_font}()},
\code{\link{opt_table_lines}()},
\code{\link{opt_table_outline}()},
\code{\link{opt_vertical_padding}()}
}
\concept{table option functions}
