% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nls_methods.R
\name{predict.gsl_nls}
\alias{predict.gsl_nls}
\title{Calculate model predicted values}
\usage{
\method{predict}{gsl_nls}(
  object,
  newdata,
  scale = NULL,
  interval = c("none", "confidence", "prediction"),
  level = 0.95,
  ...
)
}
\arguments{
\item{object}{An object inheriting from class \code{"gsl_nls"}.}

\item{newdata}{A named list or data.frame in which to look for variables with which to predict. If
\code{newdata} is missing, the predicted values at the original data points are returned.}

\item{scale}{A numeric scalar or vector. If it is set, it is used as the residual standard deviation
(or vector of residual standard deviations) in the computation of the standard errors, otherwise
this information is extracted from the model fit.}

\item{interval}{A character string indicating if confidence or prediction (tolerance) intervals
at the specified level should be returned.}

\item{level}{A numeric scalar between 0 and 1 giving the confidence level for the intervals (if any)
to be calculated.}

\item{...}{At present no optional arguments are used.}
}
\value{
If \code{interval = "none"} (default), a vector of predictions for the mean response. Otherwise,
a matrix with columns \code{fit}, \code{lwr} and \code{upr}. The first column (\code{fit}) contains
predictions for the mean response. The other two columns contain lower (\code{lwr}) and upper (\code{upr})
confidence or prediction bounds at the specified \code{level}.
}
\description{
Returns predicted values for the expected response from a fitted \code{"gsl_nls"} object.
Asymptotic confidence or prediction (tolerance) intervals at a given \code{level} can be evaluated
by specifying the appropriate \code{interval} argument.
}
\examples{
## data
set.seed(1)
n <- 50
xy <- data.frame(
  x = (1:n) / n, 
  y = 2.5 * exp(-1.5 * (1:n) / n) + rnorm(n, sd = 0.1)
)
## model
obj <- gsl_nls(fn = y ~ A * exp(-lam * x), data = xy, start = c(A = 1, lam = 1))

predict(obj)
predict(obj, newdata = data.frame(x = 1:(2 * n) / n))
predict(obj, interval = "confidence")
predict(obj, interval = "prediction", level = 0.99)
}
\seealso{
\code{\link[stats]{predict.nls}}
}
