% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fixed_design_ahr.R, R/fixed_design_fh.R,
%   R/fixed_design_lf.R, R/fixed_design_maxcombo.R, R/fixed_design_mb.R,
%   R/fixed_design_milestone.R, R/fixed_design_rd.R, R/fixed_design_rmst.R
\name{fixed_design_ahr}
\alias{fixed_design_ahr}
\alias{fixed_design_fh}
\alias{fixed_design_lf}
\alias{fixed_design_maxcombo}
\alias{fixed_design_mb}
\alias{fixed_design_milestone}
\alias{fixed_design_rd}
\alias{fixed_design_rmst}
\title{Fixed design under non-proportional hazards}
\usage{
fixed_design_ahr(
  enroll_rate,
  fail_rate,
  alpha = 0.025,
  power = NULL,
  ratio = 1,
  study_duration = 36,
  event = NULL
)

fixed_design_fh(
  alpha = 0.025,
  power = NULL,
  ratio = 1,
  study_duration = 36,
  enroll_rate,
  fail_rate,
  rho = 0,
  gamma = 0
)

fixed_design_lf(
  alpha = 0.025,
  power = NULL,
  ratio = 1,
  study_duration = 36,
  enroll_rate,
  fail_rate
)

fixed_design_maxcombo(
  alpha = 0.025,
  power = NULL,
  ratio = 1,
  study_duration = 36,
  enroll_rate,
  fail_rate,
  rho = c(0, 0, 1),
  gamma = c(0, 1, 0),
  tau = rep(-1, 3)
)

fixed_design_mb(
  alpha = 0.025,
  power = NULL,
  ratio = 1,
  study_duration = 36,
  enroll_rate,
  fail_rate,
  tau = 6,
  w_max = Inf
)

fixed_design_milestone(
  alpha = 0.025,
  power = NULL,
  ratio = 1,
  enroll_rate,
  fail_rate,
  study_duration = 36,
  tau = NULL
)

fixed_design_rd(
  alpha = 0.025,
  power = NULL,
  ratio = 1,
  p_c,
  p_e,
  rd0 = 0,
  n = NULL
)

fixed_design_rmst(
  alpha = 0.025,
  power = NULL,
  ratio = 1,
  study_duration = 36,
  enroll_rate,
  fail_rate,
  tau = NULL
)
}
\arguments{
\item{enroll_rate}{Enrollment rates defined by \code{define_enroll_rate()}.}

\item{fail_rate}{Failure and dropout rates defined by \code{define_fail_rate()}.}

\item{alpha}{One-sided Type I error (strictly between 0 and 1).}

\item{power}{Power (\code{NULL} to compute power or strictly between 0
and \code{1 - alpha} otherwise).}

\item{ratio}{Experimental:Control randomization ratio.}

\item{study_duration}{Study duration.}

\item{event}{A numerical vector specifying the targeted events at each analysis. See details.}

\item{rho}{A vector of numbers paring with gamma and tau for MaxCombo test.}

\item{gamma}{A vector of numbers paring with rho and tau for MaxCombo test.}

\item{tau}{Test parameter in RMST.}

\item{w_max}{Test parameter of Magirr-Burman method.}

\item{p_c}{A numerical value of the control arm rate.}

\item{p_e}{A numerical value of the experimental arm rate.}

\item{rd0}{Risk difference under null hypothesis, default is 0.}

\item{n}{Sample size. If NULL with power input, the sample size will be
computed to achieve the targeted power}
}
\value{
A list of design characteristic summary.
}
\description{
Computes fixed design sample size (given power)
or power (given sample size) by:
\itemize{
\item \code{\link[=fixed_design_ahr]{fixed_design_ahr()}} - Average hazard ratio method.
\item \code{\link[=fixed_design_fh]{fixed_design_fh()}} - Weighted logrank test with Fleming-Harrington
weights (Farrington and Manning, 1990).
\item \code{\link[=fixed_design_mb]{fixed_design_mb()}} - Weighted logrank test with Magirr-Burman weights.
\item \code{\link[=fixed_design_lf]{fixed_design_lf()}} - Lachin-Foulkes method (Lachin and Foulkes, 1986).
\item \code{\link[=fixed_design_maxcombo]{fixed_design_maxcombo()}} - MaxCombo method.
\item \code{\link[=fixed_design_rmst]{fixed_design_rmst()}} - RMST method.
\item \code{\link[=fixed_design_milestone]{fixed_design_milestone()}} - Milestone method.
}

Additionally, \code{\link[=fixed_design_rd]{fixed_design_rd()}} provides fixed design for binary endpoint
with treatment effect measuring in risk difference.
}
\examples{
# AHR method ----
library(dplyr)

# Example 1: given power and compute sample size
x <- fixed_design_ahr(
  alpha = .025, power = .9,
  enroll_rate = define_enroll_rate(duration = 18, rate = 1),
  fail_rate = define_fail_rate(
    duration = c(4, 100),
    fail_rate = log(2) / 12,
    hr = c(1, .6),
    dropout_rate = .001
  ),
  study_duration = 36
)
x \%>\% summary()

# Example 2: given sample size and compute power
x <- fixed_design_ahr(
  alpha = .025,
  enroll_rate = define_enroll_rate(duration = 18, rate = 20),
  fail_rate = define_fail_rate(
    duration = c(4, 100),
    fail_rate = log(2) / 12,
    hr = c(1, .6),
    dropout_rate = .001
  ),
  study_duration = 36
)
x \%>\% summary()

# WLR test with FH weights ----
library(dplyr)

# Example 1: given power and compute sample size
x <- fixed_design_fh(
  alpha = .025, power = .9,
  enroll_rate = define_enroll_rate(duration = 18, rate = 1),
  fail_rate = define_fail_rate(
    duration = c(4, 100),
    fail_rate = log(2) / 12,
    hr = c(1, .6),
    dropout_rate = .001
  ),
  study_duration = 36,
  rho = 1, gamma = 1
)
x \%>\% summary()

# Example 2: given sample size and compute power
x <- fixed_design_fh(
  alpha = .025,
  enroll_rate = define_enroll_rate(duration = 18, rate = 20),
  fail_rate = define_fail_rate(
    duration = c(4, 100),
    fail_rate = log(2) / 12,
    hr = c(1, .6),
    dropout_rate = .001
  ),
  study_duration = 36,
  rho = 1, gamma = 1
)
x \%>\% summary()

# LF method ----
library(dplyr)

# Example 1: given power and compute sample size
x <- fixed_design_lf(
  alpha = .025, power = .9,
  enroll_rate = define_enroll_rate(duration = 18, rate = 1),
  fail_rate = define_fail_rate(
    duration = 100,
    fail_rate = log(2) / 12,
    hr = .7,
    dropout_rate = .001
  ),
  study_duration = 36
)
x \%>\% summary()

# Example 2: given sample size and compute power
x <- fixed_design_lf(
  alpha = .025,
  enroll_rate = define_enroll_rate(duration = 18, rate = 20),
  fail_rate = define_fail_rate(
    duration = 100,
    fail_rate = log(2) / 12,
    hr = .7,
    dropout_rate = .001
  ),
  study_duration = 36
)
x \%>\% summary()

# MaxCombo test ----
library(dplyr)

# Example 1: given power and compute sample size
x <- fixed_design_maxcombo(
  alpha = .025, power = .9,
  enroll_rate = define_enroll_rate(duration = 18, rate = 1),
  fail_rate = define_fail_rate(
    duration = c(4, 100),
    fail_rate = log(2) / 12,
    hr = c(1, .6),
    dropout_rate = .001
  ),
  study_duration = 36,
  rho = c(0, 0.5), gamma = c(0, 0), tau = c(-1, -1)
)
x \%>\% summary()

# Example 2: given sample size and compute power
x <- fixed_design_maxcombo(
  alpha = .025,
  enroll_rate = define_enroll_rate(duration = 18, rate = 20),
  fail_rate = define_fail_rate(
    duration = c(4, 100),
    fail_rate = log(2) / 12,
    hr = c(1, .6),
    dropout_rate = .001
  ),
  study_duration = 36,
  rho = c(0, 0.5), gamma = c(0, 0), tau = c(-1, -1)
)
x \%>\% summary()

# WLR test with MB weights ----
library(dplyr)

# Example 1: given power and compute sample size
x <- fixed_design_mb(
  alpha = .025, power = .9,
  enroll_rate = define_enroll_rate(duration = 18, rate = 1),
  fail_rate = define_fail_rate(
    duration = c(4, 100),
    fail_rate = log(2) / 12,
    hr = c(1, .6),
    dropout_rate = .001
  ),
  study_duration = 36,
  tau = 4,
  w_max = 2
)
x \%>\% summary()

# Example 2: given sample size and compute power
x <- fixed_design_mb(
  alpha = .025,
  enroll_rate = define_enroll_rate(duration = 18, rate = 20),
  fail_rate = define_fail_rate(
    duration = c(4, 100),
    fail_rate = log(2) / 12,
    hr = c(1, .6),
    dropout_rate = .001
  ),
  study_duration = 36,
  tau = 4,
  w_max = 2
)
x \%>\% summary()

# Milestone method ----
library(dplyr)

# Example 1: given power and compute sample size
x <- fixed_design_milestone(
  alpha = .025, power = .9,
  enroll_rate = define_enroll_rate(duration = 18, rate = 1),
  fail_rate = define_fail_rate(
    duration = 100,
    fail_rate = log(2) / 12,
    hr = .7,
    dropout_rate = .001
  ),
  study_duration = 36,
  tau = 18
)
x \%>\% summary()

# Example 2: given sample size and compute power
x <- fixed_design_milestone(
  alpha = .025,
  enroll_rate = define_enroll_rate(duration = 18, rate = 20),
  fail_rate = define_fail_rate(
    duration = 100,
    fail_rate = log(2) / 12,
    hr = .7,
    dropout_rate = .001
  ),
  study_duration = 36,
  tau = 18
)
x \%>\% summary()

# Binary endpoint with risk differences ----
library(dplyr)

# Example 1: given power and compute sample size
x <- fixed_design_rd(
  alpha = 0.025, power = 0.9, p_c = .15, p_e = .1,
  rd0 = 0, ratio = 1
)
x \%>\% summary()

# Example 2: given sample size and compute power
x <- fixed_design_rd(
  alpha = 0.025, power = NULL, p_c = .15, p_e = .1,
  rd0 = 0, n = 2000, ratio = 1
)
x \%>\% summary()

# RMST method ----
library(dplyr)

# Example 1: given power and compute sample size
x <- fixed_design_rmst(
  alpha = .025, power = .9,
  enroll_rate = define_enroll_rate(duration = 18, rate = 1),
  fail_rate = define_fail_rate(
    duration = 100,
    fail_rate = log(2) / 12,
    hr = .7,
    dropout_rate = .001
  ),
  study_duration = 36,
  tau = 18
)
x \%>\% summary()

# Example 2: given sample size and compute power
x <- fixed_design_rmst(
  alpha = .025,
  enroll_rate = define_enroll_rate(duration = 18, rate = 20),
  fail_rate = define_fail_rate(
    duration = 100,
    fail_rate = log(2) / 12,
    hr = .7,
    dropout_rate = .001
  ),
  study_duration = 36,
  tau = 18
)
x \%>\% summary()
}
