% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/process.R
\name{gr_get_gaps}
\alias{gr_get_gaps}
\title{Get gaps in the daily data}
\usage{
gr_get_gaps(hdata)
}
\arguments{
\item{hdata}{\code{data.frame} with at least two columns, where the first column is \code{Date}}
}
\value{
\code{data.frame} with periods of data and periods of gaps, containing five columns: number of the period (num), start of the period (start_date), end of the period (end_date), duration of the period (duration) and type of the period (type).
}
\description{
Use the function to detect periods of missing data. The first column must be of \code{Date} type. The data is considered to be a gap if any value in the row is missing.
}
\examples{
library(grwat)
library(dplyr)

# example Spas-Zagorye data is included with grwat package
path = system.file("extdata", "spas-zagorye.txt", 
                   package = "grwat")

hdata_raw = read.delim(path, header = FALSE, 
                       sep = ' ', na.strings = c('-999', '-999.0', '-'),
                       col.names = c('d', 'm', 'y', 'q'))

hdata = hdata_raw \%>\% 
  transmute(Date = lubridate::make_date(y, m, d), 
            Q = q)

head(hdata)

# identify gaps
gr_get_gaps(hdata) 

# fill gaps
fhdata = gr_fill_gaps(hdata, autocorr = 0.8)

# check the results
gr_get_gaps(fhdata)

# fill gaps
fhdata = gr_fill_gaps(hdata, nobserv = 7)

# check the results
gr_get_gaps(fhdata)
}
