% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/predict.cv.grpreg.R
\name{predict.cv.grpreg}
\alias{predict.cv.grpreg}
\title{Model predictions for a fitted \code{cv.grpreg} object}
\usage{
\method{predict}{cv.grpreg}(object, newdata, type = c("response", "class",
  "probability"), ...)
}
\arguments{
\item{object}{A fitted "\code{grpreg}" object from \code{\link{grpss}},
or \code{\link[grpreg]{cv.grpreg}} function.}

\item{newdata}{Optionally, a matrix or data frame where to predict. If omits, the fitted
predictors are used.}

\item{type}{The type of prediction: "\code{response}" gives the fitted values; \code{"class"}
returns the predicted class for the binomial outcome; "\code{probability}" returns the
predicted probabilities for the logistic regression.}

\item{...}{Not used.}
}
\value{
The predicted values depending on the type.
}
\description{
Similar to usual predict methods and
\code{predict.cv.grpreg} in \code{grpreg} package.
}
\details{
This function gives the predictions at \code{newdata} or all predictors if the
argument \code{newdata} is not supplied. Typically, \code{type = "response"} is
used for linear or poisson regression, and \code{type = "class"} or
\code{type = "probability"} is used for logistic regression.
}
\examples{
library(MASS)
set.seed(23)
n <- 30 # sample size
p <- 3  # number of predictors in each group
J <- 50  # group size
group <- rep(1:J,each = 3)  # group indices
X <- mvrnorm(n,seq(0,5,length.out = p*J),diag(p*J))
beta <- runif(12,-2,5)
mu <- X\%*\%matrix(c(beta,rep(0,p*J-12)),ncol = 1)

# linear regression with family = "gaussian"
y <-  mu + rnorm(n)

## with cross-validation
gss11 <- grpss(X,y,group,select = TRUE,cross.validation = TRUE)
predict(gss11)  # fitted values
predict(gss11, newdata = X[1,])  # predicted values at given 'newdata'

# logistic regression with family = "binomial"
set.seed(23)
y1 <- rbinom(n,1,1/(1 + exp(-mu)))
gss21 <- grpss(X,y1,group, criterion = "gDC",select = TRUE,
               family = "binomial")
predict(gss21)
}
\author{
Debin Qiu, Jeongyoun Ahn
}
\seealso{
\code{\link{grpss}}
}

