% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/distcorr.R
\name{distcor}
\alias{distcor}
\title{Compute the distance correlation}
\usage{
distcor(X, y)
}
\arguments{
\item{X}{A numeric vector or matrix.}

\item{y}{A numeric vector or matrix.}
}
\value{
A sample distance correlation.
}
\description{
Computes the distance correlation between two random variables.
}
\details{
Distance correlation measures the statistical dependence between two random
variables or two random vectors. The important property is that the distance correlation
is zero if and only if two random variables are independent. The details of computing
the distance correlation can be seen in Szekely, Rizzo and Bakirov (2007) or
\url{https://en.wikipedia.org/wiki/Distance_correlation}. This function is the same as
\code{dcor} in \code{energy} package.
}
\examples{
X <- matrix(rnorm(200),ncol = 2)
y <- X\%*\%matrix(c(1.5,4),ncol = 1) + rnorm(100) # univariate y
distcor(X,y)

X <- iris[1:50, 1:4]
Y <- iris[51:100, 1:4]   # multiple response y
distcor(X,Y)
}
\author{
Debin Qiu, Jeongyoun Ahn
}
\references{
Szekely, G.J., Rizzo, M.L., and Bakirov, N.K. (2007), Measuring and Testing Dependence
by Correlation of Distances, \emph{Annals of Statistics}, Vol. 35 No. 6, pp. 2769-2794.
}

