% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graphing.R
\name{plot_resp}
\alias{plot_resp}
\title{Plot smooth terms prediction with confidence intervals}
\usage{
plot_resp(robj, ...)
}
\arguments{
\item{robj}{R object from the modelling functions.}

\item{...}{Additional arguments passed to \code{ci_resp()}.}
}
\value{
A list of ggplot objects, one per smooth term.
}
\description{
This function generates ggplot objects for each smooth term in a GAM model.
Predictions vary one smooth term at a time, keeping all other terms fixed at reference values.
Confidence intervals are computed using \code{ci_resp()}, supporting multiple methods:
"delta_link", "delta_resp", "bootstrap_link", "bootstrap_resp", and "posterior".
Small samples automatically trigger the "posterior" method for more robust CIs.
}
\examples{

# loading processed data
dt.samples_trt <- readRDS(system.file("extdata", "dt.samples_trt.rds", package = "growthTrendR"))
# climate
dt.clim <- data.table::fread(system.file("extdata", "dt.clim.csv", package = "growthTrendR"))
# pre-data for model
dt.samples_clim <- prepare_samples_clim(dt.samples_trt, dt.clim)
dt.m <- dt.samples_clim[ageC >1]
# gamm_site model
m.spatial <-gamm_spatial(
  data = dt.m, resp_scale = "resp_log",
  m.candidates = c( "bai_cm2 ~ log(ba_cm2_t_1) + s(ageC) + s(FFD)"))
plots.lst <- plot_resp(m.spatial)


}
