% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{load_measured_data}
\alias{load_measured_data}
\alias{load_data_for_sites}
\alias{load_matching_data}
\title{Load experimental data}
\usage{
load_measured_data(filenames)

load_data_for_sites(sites)

load_matching_data(filenames)
}
\arguments{
\item{filenames}{Vector of strings representing simulation output
filenames.}

\item{sites}{Vector of site names for which data to load.}
}
\value{
measured_data list of data.frame each corresponding to one of
the sites detected in \emph{filenames}. Each data.frame contains the keys
\itemize{
\item dBM
\item cBM
\item year
\item DOY
}
}
\description{
Load all datasets associated with any site present in the supplied vector.

Upon loading, the cumulative biomass growth \emph{cBM} is automatically
calculated from the given daily biomass growth \emph{dBM} values.
}
\details{
\code{load_matching_data()} internally uses \code{\link[=get_site_name]{get_site_name()}} and makes the same
assumptions about the output filename formats. It further assumes measured
data to be located in "data/" and adhere to the filename format \code{x.csv}
with \code{x} being the site name.
}
\section{Functions}{
\itemize{
\item \code{load_data_for_sites()}: Data filenames are generated on the convention `SITE.csv` and are searched 
for in the subdirectory `getOption("growR.data_dir")`, which defaults 
to `data/`.

\item \code{load_matching_data()}: Accepts a vector of output filenames as generated by
\link{ModvegeSite}\verb{$write_output()} out of which the site names are inferred.

}}
