% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/InvDWT.R
\name{InvDWT}
\alias{InvDWT}
\title{Inverse discrete wavelet transform}
\usage{
InvDWT(grove.obj, x = NULL, include.C = TRUE, sample.C = FALSE)
}
\arguments{
\item{grove.obj}{An object of class \code{grove}.}

\item{x}{A vector of the values of a predictor.}

\item{include.C}{If \code{TRUE}, C is used for reconstructing
the function.}

\item{sample.C}{If \code{TRUE}, draws from C are used for recontructing
the function.}
}
\value{
A matrix with each row representing a draw from the reconstructed signal.
}
\description{
This function performs the inverse discrete wavelet transform.
}
\examples{
data <- wavethresh::DJ.EX(n = 512, noisy = TRUE, rsnr = 5)$doppler
W <- DWT(data)
ans <- Denoise(W)
denoised.data <- InvDWT(ans)
plot(data, type = "l")
lines(denoised.data[1, ], col = "red")
}

