% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aesthetics.R
\name{add_aesthetic}
\alias{add_aesthetic}
\title{Add an Aesthetic}
\usage{
add_aesthetic(
  grob_object,
  aesthetic,
  value = NULL,
  group = c("cells", "column_names", "column_headings")
)
}
\arguments{
\item{grob_object}{The R6 object outputted by either \code{\link{grob_matrix}}
or \code{\link{grob_text}}.}

\item{aesthetic}{The matrix aesthetic the user wishes to add.}

\item{value}{A single value or a matrix of values the user wants to apply to the group of matrix / text 
elements for the given aesthetic.

If a matrix of values is supplied, then the matrix must be of the same dimensions
as the chosen subset of the matrix / text.}

\item{group}{The group of the grob matrix object the user wants to add the 
aesthetic to. 

For objects initialized by \code{\link{grob_matrix}}, the user can add an aesthetic to the 'cells', the
'column_names' or the 'column_headings'. If the user is passing through an object 
initialized by \code{\link{grob_text}}, then only 'cells' will be accepted.}
}
\value{
The R6 object of the grob matrix class with its aesthetics properties altered.
}
\description{
Add an aesthetic to a grob matrix object.
}
\details{
Accepted aesthetics:

\describe{

\item{Matrix / Text}{

\itemize{

\item \code{background_alpha}
\item \code{background_color}
\item \code{border_color}
\item \code{border_sides}
\item \code{border_width}
\item \code{font_face}
\item \code{group_elements}
\item \code{replace_na}
\item \code{round_rect_radius}
\item \code{text_align}
\item \code{text_cex}
\item \code{text_font}
\item \code{text_color}
\item \code{text_just}
\item \code{text_v_align}
\item \code{text_v_just}
\item \code{text_rot}

}
}

}

To see descriptions of the aesthetics above, see the documentation of \code{\link{ga_list}}.
}
\examples{

df = data.frame(var1 = c(5, 14, 6, 10), var2 = c(3, 30, 17, 7))
df \%>\%
  grob_matrix() \%>\% 
  add_aesthetic(aesthetic = 'text_color', value = 'red', group = 'cells') \%>\%
  view_grob()

}
